/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.kafka.helper;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.kafka.helper.ConsumerRecordsIterableWrapper;
import co.elastic.apm.agent.kafka.helper.ConsumerRecordsIteratorWrapper;
import co.elastic.apm.agent.kafka.helper.ConsumerRecordsListWrapper;
import co.elastic.apm.agent.kafka.helper.KafkaRecordHeaderAccessor;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KafkaInstrumentationHeadersHelper {
    private static final Logger logger = LoggerFactory.getLogger(KafkaInstrumentationHeadersHelper.class);
    private static final KafkaInstrumentationHeadersHelper INSTANCE = new KafkaInstrumentationHeadersHelper(GlobalTracer.requireTracerImpl());
    private static final ThreadLocal<Boolean> wrappingDisabled = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final ElasticApmTracer tracer;

    public static KafkaInstrumentationHeadersHelper get() {
        return INSTANCE;
    }

    public KafkaInstrumentationHeadersHelper(ElasticApmTracer tracer) {
        this.tracer = tracer;
    }

    public Iterator<ConsumerRecord<?, ?>> wrapConsumerRecordIterator(Iterator<ConsumerRecord<?, ?>> consumerRecordIterator) {
        try {
            return new ConsumerRecordsIteratorWrapper(consumerRecordIterator, this.tracer);
        }
        catch (Throwable throwable) {
            logger.debug("Failed to wrap Kafka ConsumerRecords iterator", throwable);
            return consumerRecordIterator;
        }
    }

    public Iterable<ConsumerRecord<?, ?>> wrapConsumerRecordIterable(Iterable<ConsumerRecord<?, ?>> consumerRecordIterable) {
        try {
            return new ConsumerRecordsIterableWrapper(consumerRecordIterable, this.tracer);
        }
        catch (Throwable throwable) {
            logger.debug("Failed to wrap Kafka ConsumerRecords", throwable);
            return consumerRecordIterable;
        }
    }

    public List<ConsumerRecord<?, ?>> wrapConsumerRecordList(List<ConsumerRecord<?, ?>> consumerRecordList) {
        try {
            return new ConsumerRecordsListWrapper(consumerRecordList, this.tracer);
        }
        catch (Throwable throwable) {
            logger.debug("Failed to wrap Kafka ConsumerRecords list", throwable);
            return consumerRecordList;
        }
    }

    public boolean shouldWrapIterable(ConsumerRecords<?, ?> consumerRecords, @Nullable Object iterable) {
        if (wrappingDisabled.get().booleanValue() || !this.tracer.isRunning() || iterable == null) {
            return false;
        }
        AbstractSpan<?> activeSpan = this.tracer.getActive();
        if (activeSpan != null) {
            this.addSpanLinks(consumerRecords, activeSpan);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSpanLinks(@Nullable ConsumerRecords<?, ?> records, AbstractSpan<?> span) {
        if (records != null && !records.isEmpty()) {
            wrappingDisabled.set(Boolean.TRUE);
            try {
                for (ConsumerRecord record : records) {
                    span.addSpanLink(TraceContext.getFromTraceContextBinaryHeaders(), KafkaRecordHeaderAccessor.instance(), record);
                }
            }
            finally {
                wrappingDisabled.set(false);
            }
        }
    }

    public void setOutgoingTraceContextHeaders(Span span, ProducerRecord<?, ?> producerRecord) {
        span.propagateTraceContext(producerRecord, KafkaRecordHeaderAccessor.instance());
    }

    public void removeTraceContextHeader(ProducerRecord<?, ?> producerRecord) {
        TraceContext.removeTraceContextHeaders(producerRecord, KafkaRecordHeaderAccessor.instance());
    }
}

