/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.kafka;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.kafka.BaseKafkaInstrumentation;
import co.elastic.apm.agent.kafka.helper.KafkaInstrumentationHelper;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KafkaProducerInstrumentation
extends BaseKafkaInstrumentation {
    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return super.getClassLoaderMatcher().and(ElementMatchers.not(CustomElementMatchers.classLoaderCanLoadClass("org.apache.kafka.common.header.Headers")));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("org.apache.kafka.clients.producer.KafkaProducer");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.isPublic().and(ElementMatchers.named("send")).and(ElementMatchers.takesArgument(0, ElementMatchers.named("org.apache.kafka.clients.producer.ProducerRecord"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("org.apache.kafka.clients.producer.Callback")));
    }

    @Override
    public String getAdviceClassName() {
        return this.getClass().getName() + "$KafkaProducerAdvice";
    }

    public static class KafkaProducerAdvice {
        public static final KafkaInstrumentationHelper helper = KafkaInstrumentationHelper.get();

        @Nullable
        @Advice.AssignReturned.ToArguments(value={@Advice.AssignReturned.ToArguments.ToArgument(value=1)})
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Callback beforeSend(@Advice.Argument(value=0) ProducerRecord<?, ?> record, @Advice.Argument(value=1) @Nullable Callback callback) {
            Span span = helper.onSendStart(record);
            if (span == null) {
                return callback;
            }
            return helper.wrapCallback(callback, span);
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class, inline=false)
        public static void afterSend(@Advice.Argument(value=0) ProducerRecord<?, ?> record, @Advice.This KafkaProducer<?, ?> thiz, @Advice.Thrown Throwable throwable) {
            Span span = TracerAwareInstrumentation.tracer.getActiveExitSpan();
            if (span != null) {
                helper.onSendEnd(span, record, thiz, throwable);
            }
        }
    }
}

