/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.kafka;

import co.elastic.apm.agent.kafka.KafkaConsumerRecordsInstrumentation;
import co.elastic.apm.agent.kafka.helper.KafkaInstrumentationHeadersHelper;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;

public class ConsumerRecordsRecordsInstrumentation
extends KafkaConsumerRecordsInstrumentation {
    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("records").and(ElementMatchers.isPublic()).and(ElementMatchers.takesArgument(0, String.class)).and(ElementMatchers.returns(Iterable.class));
    }

    @Override
    public String getAdviceClassName() {
        return this.getClass().getName() + "$ConsumerRecordsAdvice";
    }

    public static class ConsumerRecordsAdvice {
        private static final KafkaInstrumentationHeadersHelper helper = KafkaInstrumentationHeadersHelper.get();

        @Nullable
        @Advice.AssignReturned.ToReturned
        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class, inline=false)
        public static Iterable<ConsumerRecord<?, ?>> wrapIterable(@Advice.This ConsumerRecords<?, ?> thiz, @Advice.Return @Nullable Iterable<ConsumerRecord<?, ?>> iterable) {
            if (helper.shouldWrapIterable(thiz, iterable)) {
                return helper.wrapConsumerRecordIterable(iterable);
            }
            return iterable;
        }
    }
}

