/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jul.reformatting;

import co.elastic.apm.agent.jul.reformatting.AbstractJulEcsReformattingHelper;
import co.elastic.apm.agent.loginstr.reformatting.Utils;
import co.elastic.apm.agent.util.PrivilegedActionUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import javax.annotation.Nullable;

class JulEcsReformattingHelper
extends AbstractJulEcsReformattingHelper {
    private static final ThreadLocal<String> currentPattern = new ThreadLocal();
    private static final ThreadLocal<Path> currentExampleLogFile = new ThreadLocal();

    JulEcsReformattingHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onAppendEnter(FileHandler fileHandler, String pattern, File exampleLogFile) {
        try {
            currentPattern.set(pattern);
            currentExampleLogFile.set(exampleLogFile.toPath());
            boolean bl = super.onAppendEnter(fileHandler);
            return bl;
        }
        finally {
            currentPattern.remove();
            currentExampleLogFile.remove();
        }
    }

    @Override
    protected String getAppenderName(Handler handler) {
        if (handler instanceof FileHandler) {
            return "FILE";
        }
        if (handler instanceof ConsoleHandler) {
            return "CONSOLE";
        }
        return handler.getClass().getSimpleName();
    }

    @Override
    protected boolean isFileHandler(Handler originalHandler) {
        return originalHandler instanceof FileHandler;
    }

    @Override
    protected String getShadeFilePatternAndCreateDir() throws IOException {
        return JulEcsReformattingHelper.computeEcsFileHandlerPattern(currentPattern.get(), currentExampleLogFile.get(), this.getConfiguredReformattingDir(), true);
    }

    static String computeEcsFileHandlerPattern(String pattern, Path originalFilePath, @Nullable String configuredReformattingDir, boolean createDirs) throws IOException {
        Path logReformattingDir;
        int lastPathSeparatorIndex;
        if (!(pattern = Utils.replaceFileExtensionToEcsJson(pattern)).contains("%g")) {
            pattern = pattern + ".%g";
        }
        if ((lastPathSeparatorIndex = pattern.lastIndexOf(47)) > 0 && lastPathSeparatorIndex < pattern.length() - 1) {
            pattern = pattern.substring(lastPathSeparatorIndex + 1);
        }
        if ((logReformattingDir = Utils.computeLogReformattingDir(originalFilePath, configuredReformattingDir)) != null) {
            if (createDirs) {
                PrivilegedActionUtils.createDirectories(logReformattingDir);
            }
            pattern = logReformattingDir.resolve(pattern).toString();
        }
        return pattern;
    }
}

