/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jul.reformatting;

import co.elastic.apm.agent.loginstr.correlation.CorrelationIdMapAdapter;
import co.elastic.apm.agent.loginstr.reformatting.AbstractEcsReformattingHelper;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.util.LoggerUtils;
import co.elastic.logging.AdditionalField;
import co.elastic.logging.jul.EcsFormatter;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import javax.annotation.Nullable;

public abstract class AbstractJulEcsReformattingHelper
extends AbstractEcsReformattingHelper<Handler, Formatter> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJulEcsReformattingHelper.class);
    private static final Logger oneTimeLogFileLimitWarningLogger = LoggerUtils.logOnce(logger);

    @Override
    @Nullable
    protected Formatter getFormatterFrom(Handler handler) {
        return handler.getFormatter();
    }

    @Override
    protected void setFormatter(Handler handler, Formatter formatter) {
        handler.setFormatter(formatter);
    }

    @Override
    protected void closeShadeAppender(Handler handler) {
        handler.close();
    }

    @Override
    @Nullable
    public Formatter createEcsFormatter(String eventDataset, @Nullable String serviceName, @Nullable String serviceVersion, @Nullable String serviceNodeName, @Nullable Map<String, String> additionalFields, Formatter originalFormatter) {
        EcsFormatter ecsFormatter = new EcsFormatter(){

            @Override
            protected Map<String, String> getMdcEntries() {
                return CorrelationIdMapAdapter.get();
            }
        };
        ecsFormatter.setServiceName(serviceName);
        ecsFormatter.setServiceVersion(serviceVersion);
        ecsFormatter.setServiceNodeName(serviceNodeName);
        ecsFormatter.setEventDataset(eventDataset);
        if (additionalFields != null && !additionalFields.isEmpty()) {
            ArrayList<AdditionalField> additionalFieldList = new ArrayList<AdditionalField>();
            for (Map.Entry<String, String> keyValuePair : additionalFields.entrySet()) {
                additionalFieldList.add(new AdditionalField(keyValuePair.getKey(), keyValuePair.getValue()));
            }
            ecsFormatter.setAdditionalFields(additionalFieldList);
        }
        ecsFormatter.setIncludeOrigin(false);
        ecsFormatter.setStackTraceAsArray(false);
        return ecsFormatter;
    }

    protected abstract String getShadeFilePatternAndCreateDir() throws IOException;

    @Override
    @Nullable
    protected Handler createAndStartEcsAppender(Handler originalHandler, String ecsAppenderName, Formatter ecsFormatter) {
        FileHandler shadeHandler = null;
        if (this.isFileHandler(originalHandler)) {
            try {
                String pattern = this.getShadeFilePatternAndCreateDir();
                int maxLogFileSize = (int)this.getMaxLogFileSize();
                if ((long)maxLogFileSize != this.getMaxLogFileSize()) {
                    maxLogFileSize = (int)this.getDefaultMaxLogFileSize();
                    oneTimeLogFileLimitWarningLogger.warn("Configured log max size ({} bytes) is too big for JUL settings, which use int to configure the file size limit. Consider reducing the log max size configuration to a value below Integer#MAX_VALUE. Defaulting to {} bytes.", (Object)this.getMaxLogFileSize(), (Object)maxLogFileSize);
                }
                shadeHandler = AbstractJulEcsReformattingHelper.createFileHandler(pattern, maxLogFileSize);
                shadeHandler.setFormatter(ecsFormatter);
            }
            catch (Exception e) {
                logger.error("Failed to create Log shading FileAppender. Auto ECS reformatting will not work.", e);
            }
        }
        return shadeHandler;
    }

    private static FileHandler createFileHandler(final String pattern, final int maxLogFileSize) throws IOException {
        if (System.getSecurityManager() == null) {
            return AbstractJulEcsReformattingHelper.doCreateFileHandler(pattern, maxLogFileSize);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileHandler>(){

                @Override
                public FileHandler run() throws Exception {
                    return AbstractJulEcsReformattingHelper.doCreateFileHandler(pattern, maxLogFileSize);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private static FileHandler doCreateFileHandler(String pattern, int maxLogFileSize) throws IOException {
        return new FileHandler(pattern, maxLogFileSize, 2, true);
    }

    protected abstract boolean isFileHandler(Handler var1);
}

