/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jul.error;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.loginstr.error.AbstractLoggerErrorCapturingInstrumentation;
import co.elastic.apm.agent.loginstr.error.LoggerErrorHelper;
import java.util.Collection;
import java.util.logging.LogRecord;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class JulLoggerErrorCapturingInstrumentation
extends AbstractLoggerErrorCapturingInstrumentation {
    @Override
    public Collection<String> getInstrumentationGroupNames() {
        Collection<String> ret = super.getInstrumentationGroupNames();
        ret.add("jul-error");
        return ret;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.agent.logging.JulBridgeLogger");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("log").and(ElementMatchers.takesArgument(0, ElementMatchers.named("java.util.logging.LogRecord")));
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.jul.error.JulLoggerErrorCapturingInstrumentation$LoggingAdvice";
    }

    public static class LoggingAdvice {
        private static final LoggerErrorHelper helper = new LoggerErrorHelper(LoggingAdvice.class, TracerAwareInstrumentation.tracer);

        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object onEnter(@Advice.Argument(value=0) LogRecord record, @Advice.Origin Class<?> clazz) {
            Throwable thrown = record.getThrown();
            if (record.getLevel().intValue() < 1000) {
                thrown = null;
            }
            return helper.enter(thrown, clazz);
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onExit(@Advice.Enter @Nullable Object errorCaptureObj) {
            helper.exit(errorCaptureObj);
        }
    }
}

