/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jms;

import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.jms.BaseJmsInstrumentation;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import javax.annotation.Nullable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class JmsMessageProducerInstrumentation
extends BaseJmsInstrumentation {
    public static final Logger logger = LoggerFactory.getLogger(JmsMessageProducerInstrumentation.class);

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Message").or(ElementMatchers.nameContains("Producer")).or(ElementMatchers.nameContains("Sender")).or(ElementMatchers.nameContains("Publisher"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("javax.jms.MessageProducer")));
    }

    public static class JmsMessageProducerWithDestinationInstrumentation
    extends JmsMessageProducerInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("send").and(ElementMatchers.takesArgument(0, ElementMatchers.named("javax.jms.Destination"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("javax.jms.Message"))).and(ElementMatchers.isPublic());
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.jms.JmsMessageProducerInstrumentation$JmsMessageProducerWithDestinationInstrumentation$MessageProducerWithDestinationAdvice";
        }

        public static class MessageProducerWithDestinationAdvice
        extends BaseJmsInstrumentation.BaseAdvice {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object startSpan(@Advice.Argument(value=0) Destination destination, @Advice.Argument(value=1) Message message) {
                return helper.startJmsSendSpan(destination, message);
            }

            @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class, inline=false)
            public static void endSpan(@Advice.Enter @Nullable Object spanObj, @Advice.Thrown Throwable throwable) {
                if (spanObj instanceof Span) {
                    Span span = (Span)spanObj;
                    span.captureException(throwable);
                    ((Span)span.deactivate()).end();
                }
            }
        }
    }

    public static class JmsMessageProducerNoDestinationInstrumentation
    extends JmsMessageProducerInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("send").and(ElementMatchers.takesArgument(0, ElementMatchers.named("javax.jms.Message"))).and(ElementMatchers.isPublic());
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.jms.JmsMessageProducerInstrumentation$JmsMessageProducerNoDestinationInstrumentation$MessageProducerNoDestinationAdvice";
        }

        public static class MessageProducerNoDestinationAdvice
        extends BaseJmsInstrumentation.BaseAdvice {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            @Nullable
            public static Object beforeSend(@Advice.Argument(value=0) Message message, @Advice.This MessageProducer producer) {
                try {
                    Destination destination = producer.getDestination();
                    return helper.startJmsSendSpan(destination, message);
                }
                catch (JMSException e) {
                    logger.warn("Failed to retrieve message's destination", e);
                    return null;
                }
            }

            @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class, inline=false)
            public static void afterSend(@Advice.Enter @Nullable Object spanObj, @Advice.Thrown Throwable throwable) {
                if (spanObj instanceof Span) {
                    Span span = (Span)spanObj;
                    span.captureException(throwable);
                    ((Span)span.deactivate()).end();
                }
            }
        }
    }
}

