/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jms;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.configuration.MessagingConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.jms.JmsInstrumentationHelper;
import java.util.Collection;
import java.util.Collections;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class BaseJmsInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singletonList("jms");
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.not(ElementMatchers.isBootstrapClassLoader()).and(CustomElementMatchers.classLoaderCanLoadClass("javax.jms.Message"));
    }

    protected static class BaseAdvice {
        protected static final JmsInstrumentationHelper helper;
        protected static final MessagingConfiguration messagingConfiguration;
        protected static final CoreConfiguration coreConfiguration;

        protected BaseAdvice() {
        }

        static {
            ElasticApmTracer elasticApmTracer = GlobalTracer.requireTracerImpl();
            helper = new JmsInstrumentationHelper(elasticApmTracer);
            messagingConfiguration = elasticApmTracer.getConfig(MessagingConfiguration.class);
            coreConfiguration = elasticApmTracer.getConfig(CoreConfiguration.class);
        }
    }
}

