/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jedis;

import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.redis.RedisSpanUtils;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import redis.clients.jedis.Connection;

public class SendCommandAdvice {
    @Nullable
    @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
    public static Object sendCommandEntry(@Advice.Argument(value=0) Object command) {
        return RedisSpanUtils.createRedisSpan(command.toString());
    }

    @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class, inline=false)
    public static void sendCommandExit(@Advice.This(typing=Assigner.Typing.DYNAMIC) Connection thiz, @Nullable @Advice.Enter Object spanObj, @Nullable @Advice.Thrown Throwable thrown) {
        Span span = (Span)spanObj;
        if (span != null) {
            span.getContext().getDestination().withAddress(thiz.getHost()).withPort(thiz.getPort());
            ((Span)((Span)span.captureException(thrown)).deactivate()).end();
        }
    }
}

