/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jedis;

import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.redis.RedisSpanUtils;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.DefaultJedisSocketFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisSocketFactory;

public class Jedis4SendCommandAdvice {
    @Nullable
    @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
    public static Object sendCommandEntry(@Advice.Argument(value=0) CommandArguments commandArguments) {
        return RedisSpanUtils.createRedisSpan(commandArguments.getCommand().toString());
    }

    @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class, inline=false)
    public static void sendCommandExit(@Advice.FieldValue(value="socketFactory") JedisSocketFactory socketFactory, @Nullable @Advice.Enter Object spanObj, @Nullable @Advice.Thrown Throwable thrown) {
        Span span = (Span)spanObj;
        if (span != null) {
            if (socketFactory instanceof DefaultJedisSocketFactory) {
                HostAndPort hostAndPort = ((DefaultJedisSocketFactory)socketFactory).getHostAndPort();
                span.getContext().getDestination().withAddress(hostAndPort.getHost()).withPort(hostAndPort.getPort());
            }
            ((Span)((Span)span.captureException(thrown)).deactivate()).end();
        }
    }
}

