/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jdbc.helper;

import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.sdk.state.GlobalState;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@GlobalState
public class ConnectionMetaData {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionMetaData.class);
    private final String dbVendor;
    @Nullable
    private final String host;
    private final int port;
    @Nullable
    private final String instance;
    @Nullable
    private final String user;

    private ConnectionMetaData(String dbVendor, @Nullable String host, int port, @Nullable String instance, @Nullable String user) {
        this.dbVendor = dbVendor;
        this.host = host;
        this.port = port;
        this.instance = instance;
        this.user = user;
    }

    public String getDbVendor() {
        return this.dbVendor;
    }

    @Nullable
    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Nullable
    public String getInstance() {
        return this.instance;
    }

    @Nullable
    public String getUser() {
        return this.user;
    }

    public String toString() {
        return "ConnectionMetaData{dbVendor='" + this.dbVendor + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", instance='" + this.instance + '\'' + ", user='" + this.user + '\'' + '}';
    }

    public static Builder parse(String url) {
        int indexOfNextColon;
        String vendor = "unknown";
        String vendorUrl = url;
        int indexOfJdbc = vendorUrl.indexOf("jdbc:");
        if (indexOfJdbc != -1 && (indexOfNextColon = (vendorUrl = vendorUrl.substring(indexOfJdbc + 5)).indexOf(":")) != -1) {
            vendor = vendorUrl.substring(0, indexOfNextColon);
            vendorUrl = vendorUrl.substring(indexOfNextColon + 1);
        }
        ConnectionUrlParser connectionUrlParser = ConnectionUrlParser.getParser(vendor);
        Builder builder = new Builder(vendor);
        try {
            builder = connectionUrlParser.parse(vendorUrl, builder);
        }
        catch (Exception e) {
            logger.error(String.format("Failed to parse connection URL: %s with parser %s", new Object[]{url, connectionUrlParser}), e);
            builder.withParsingError();
        }
        return builder;
    }

    @GlobalState
    public static class Builder {
        private static final String LOCALHOST = "localhost";
        @Nullable
        private String user;
        @Nullable
        private String instance;
        private String vendor;
        @Nullable
        private String host;
        private int port = -1;

        private Builder(String vendor) {
            this.vendor = vendor;
        }

        Builder withVendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public Builder withConnectionUser(@Nullable String user) {
            if (this.user == null) {
                this.user = user;
            }
            return this;
        }

        public Builder withUser(@Nullable String user) {
            this.user = user;
            return this;
        }

        public Builder withInstance(@Nullable String instance) {
            if (instance != null && instance.length() > 0) {
                this.instance = instance;
            }
            return this;
        }

        public Builder withHost(@Nullable String host) {
            if (host != null) {
                if ((host = host.toLowerCase(Locale.ROOT)).startsWith("[") && host.endsWith("]")) {
                    host = host.substring(1, host.length() - 1);
                }
                this.host = host;
            }
            return this;
        }

        public Builder withHostLocalhost() {
            this.host = LOCALHOST;
            return this;
        }

        public Builder withPort(int port) {
            if (port > 0) {
                this.port = port;
            }
            return this;
        }

        public Builder withLocalAccess() {
            this.host = LOCALHOST;
            this.port = -1;
            return this;
        }

        public Builder withConnectionInstance(@Nullable String instance) {
            if (this.instance == null) {
                this.instance = instance;
            }
            return this;
        }

        public ConnectionMetaData build() {
            return new ConnectionMetaData(this.vendor, this.host, this.port, this.instance, this.user);
        }

        public Builder withParsingError() {
            this.host = null;
            this.port = -1;
            this.instance = null;
            return this;
        }

        public boolean hasHost() {
            return this.host != null;
        }

        public boolean hasInstance() {
            return this.instance != null;
        }
    }

    private static enum ConnectionUrlParser {
        ORACLE("oracle"){

            @Override
            Builder parse(String vendorUrl, Builder builder) {
                builder.withPort(1521);
                int indexOfUserDetailsEnd = vendorUrl.indexOf(64);
                if (indexOfUserDetailsEnd > 0) {
                    if (vendorUrl.length() > indexOfUserDetailsEnd + 1) {
                        vendorUrl = vendorUrl.substring(indexOfUserDetailsEnd + 1).trim();
                    } else {
                        return builder;
                    }
                }
                if (vendorUrl.startsWith("(")) {
                    try {
                        TreeNode parsedTree = this.buildOracleTree(vendorUrl);
                        if (parsedTree == null) {
                            logger.warn("Failed to parse Oracle DB address list from: {}", (Object)vendorUrl);
                            return builder.withParsingError();
                        }
                        this.traverseOracleTree(vendorUrl, parsedTree, builder);
                    }
                    catch (Exception e) {
                        logger.warn("Failed to parse oracle description {}", (Object)vendorUrl);
                        return builder.withParsingError();
                    }
                } else if (vendorUrl.indexOf(47) >= 0) {
                    int authorityEnd;
                    String authority = vendorUrl;
                    if (authority.startsWith("//")) {
                        authority = vendorUrl.substring(2);
                    }
                    if ((authorityEnd = authority.indexOf(47)) >= 0) {
                        if (authorityEnd + 1 < authority.length()) {
                            builder.withInstance(authority.substring(authorityEnd + 1));
                        }
                        authority = authority.substring(0, authorityEnd);
                    }
                    1.parseAuthority(authority, builder);
                } else {
                    String[] parts;
                    if (vendorUrl.startsWith("thin:")) {
                        vendorUrl = vendorUrl.substring("thin:".length());
                    }
                    if ((parts = vendorUrl.split(":")).length > 0) {
                        builder.withHost(parts[0]);
                    }
                    if (parts.length > 1) {
                        String portOrDb = parts[1];
                        boolean isInt = true;
                        for (char c : portOrDb.toCharArray()) {
                            isInt = isInt && c >= '0' && c <= '9';
                        }
                        if (isInt) {
                            builder.withPort(1.toNumericPort(vendorUrl, portOrDb));
                        } else {
                            builder.withInstance(portOrDb);
                        }
                    }
                    if (parts.length > 2) {
                        builder.withInstance(parts[2]);
                    }
                }
                return builder;
            }

            @Nullable
            private TreeNode buildOracleTree(String connectionUrl) {
                TreeNode parsedTree = null;
                ArrayDeque<TreeNode> stack = new ArrayDeque<TreeNode>();
                StringBuilder currentValueBuffer = null;
                block5: for (char c : connectionUrl.toCharArray()) {
                    switch (c) {
                        case '(': {
                            TreeNode treeNode = new TreeNode();
                            if (stack.isEmpty()) {
                                parsedTree = treeNode;
                            } else {
                                ((TreeNode)stack.peek()).childNodes.add(treeNode);
                            }
                            stack.push(treeNode);
                            currentValueBuffer = treeNode.name;
                            continue block5;
                        }
                        case ')': {
                            stack.pop();
                        }
                        case '=': {
                            if (stack.isEmpty()) {
                                currentValueBuffer = null;
                                continue block5;
                            }
                            currentValueBuffer = ((TreeNode)stack.peek()).value;
                            continue block5;
                        }
                        default: {
                            if (currentValueBuffer == null) {
                                logger.warn("Failed to parse Oracle DB address list from: {}", (Object)connectionUrl);
                                continue block5;
                            }
                            currentValueBuffer.append(c);
                        }
                    }
                }
                return parsedTree;
            }

            private void traverseOracleTree(String connectionUrl, TreeNode treeNode, Builder builder) {
                String nodeName = treeNode.name.toString().toLowerCase(Locale.ROOT).trim();
                if (nodeName.equals("address")) {
                    String host = null;
                    int port = -1;
                    for (TreeNode childNode : treeNode.childNodes) {
                        String childName = childNode.name.toString().toLowerCase(Locale.ROOT).trim();
                        String childValue = childNode.value.toString().trim();
                        if (childName.equals("host")) {
                            host = childValue;
                            continue;
                        }
                        if (!childName.equals("port")) continue;
                        port = 1.toNumericPort(connectionUrl, childValue);
                    }
                    if (host != null && !builder.hasHost()) {
                        builder.withHost(host).withPort(port);
                    }
                } else if (nodeName.equals("instance_name") || nodeName.equals("service_name") && !builder.hasInstance() || nodeName.equals("sid") && !builder.hasInstance()) {
                    builder.withInstance(treeNode.value.toString().trim());
                }
                for (TreeNode childNode : treeNode.childNodes) {
                    this.traverseOracleTree(connectionUrl, childNode, builder);
                }
            }

            class TreeNode {
                final StringBuilder name = new StringBuilder();
                final StringBuilder value = new StringBuilder();
                final List<TreeNode> childNodes = new ArrayList<TreeNode>();

                TreeNode() {
                }
            }
        }
        ,
        POSTGRESQL("postgresql"){

            @Override
            Builder parse(String vendorUrl, Builder builder) {
                return this.defaultParse(vendorUrl, builder.withHostLocalhost().withPort(5432));
            }
        }
        ,
        MYSQL("mysql"){

            @Override
            Builder parse(String vendorUrl, Builder builder) {
                builder.withHostLocalhost().withPort(3306);
                3.parseMySqlFlavor(vendorUrl, builder);
                return builder;
            }
        }
        ,
        DB2("db2"){

            @Override
            Builder parse(String vendorUrl, Builder builder) {
                return this.defaultParse(vendorUrl, builder.withPort(50000));
            }

            @Override
            protected int getPropertiesStart(String vendorUrl) {
                int min;
                int semiColon;
                int twoDots;
                int hostEndSlash;
                int start = 0;
                if (vendorUrl.startsWith("//")) {
                    start = 2;
                }
                if ((hostEndSlash = vendorUrl.lastIndexOf(47)) >= 2) {
                    start = hostEndSlash;
                }
                if ((twoDots = vendorUrl.indexOf(58, start)) < 0) {
                    twoDots = Integer.MAX_VALUE;
                }
                if ((semiColon = vendorUrl.indexOf(59, start)) < 0) {
                    semiColon = Integer.MAX_VALUE;
                }
                return (min = Math.min(twoDots, semiColon)) == Integer.MAX_VALUE ? -1 : min;
            }
        }
        ,
        H2("h2"){
            private final String MEM_SUBPROTOCOL = "mem:";
            private final Set<String> LOCAL_SUBPROTOCOLS = new HashSet<String>(Arrays.asList("file:", "mem:"));

            @Override
            Builder parse(String vendorUrl, Builder builder) {
                return this.defaultParse(vendorUrl, builder);
            }

            @Override
            protected Set<String> getLocalSubProtocols() {
                return this.LOCAL_SUBPROTOCOLS;
            }
        }
        ,
        DERBY("derby"){
            private final String MEMORY_SUBPROTOCOL = "memory:";
            private final Set<String> LOCAL_SUBPROTOCOLS = new HashSet<String>(Arrays.asList("memory:", "jar:", "classpath:", "directory:"));

            @Override
            Builder parse(String vendorUrl, Builder builder) {
                if (vendorUrl.contains("//")) {
                    builder.withPort(1527);
                } else {
                    builder.withLocalAccess();
                }
                return this.defaultParse(vendorUrl, builder);
            }

            @Override
            protected Set<String> getLocalSubProtocols() {
                return this.LOCAL_SUBPROTOCOLS;
            }
        }
        ,
        HSQLDB("hsqldb"){
            private final Set<String> LOCAL_SUBPROTOCOLS = new HashSet<String>(Arrays.asList("file:", "mem:", "res:"));

            @Override
            Builder parse(String vendorUrl, Builder builder) {
                return this.defaultParse(vendorUrl, builder.withPort(9001));
            }

            @Override
            protected Set<String> getLocalSubProtocols() {
                return this.LOCAL_SUBPROTOCOLS;
            }
        }
        ,
        MARIADB("mariadb"){
            final List<String> SPECIALIZED_PROTOCOL_STRINGS = new ArrayList<String>(Arrays.asList("sequential:", "loadbalance:", "failover:", "replication:", "aurora:"));

            @Override
            Builder parse(String vendorUrl, Builder builder) {
                for (String protocol : this.SPECIALIZED_PROTOCOL_STRINGS) {
                    int indexOfProtocol = vendorUrl.indexOf(protocol);
                    if (indexOfProtocol < 0) continue;
                    vendorUrl = vendorUrl.substring(indexOfProtocol + protocol.length());
                }
                if (!vendorUrl.contains("//")) {
                    vendorUrl = "//" + vendorUrl;
                }
                builder.withHostLocalhost().withPort(3306);
                8.parseMySqlFlavor(vendorUrl, builder);
                return builder;
            }
        }
        ,
        SQLSERVER("sqlserver"){

            @Override
            Builder parse(String vendorUrl, Builder builder) {
                builder.withVendor("mssql").withHostLocalhost().withPort(1433);
                String authority = null;
                String dbName = null;
                int indexOfProperties = vendorUrl.indexOf(59);
                if (indexOfProperties < 0) {
                    authority = vendorUrl.substring(2);
                } else {
                    if (vendorUrl.length() > indexOfProperties + 1) {
                        String[] properties;
                        String propertiesPart = vendorUrl.substring(indexOfProperties + 1);
                        for (String property : properties = propertiesPart.split(";")) {
                            String[] parts = property.split("=");
                            if (parts.length != 2 || !parts[0].equals("serverName")) continue;
                            authority = parts[1];
                        }
                    }
                    if (authority == null) {
                        authority = vendorUrl.substring(2, indexOfProperties);
                    }
                }
                int backSlashIndex = authority.indexOf(92);
                if (backSlashIndex > 0) {
                    dbName = authority.substring(backSlashIndex + 1);
                    int portSeparator = dbName.indexOf(58);
                    String portSuffix = null;
                    if (portSeparator > 0) {
                        portSuffix = dbName.substring(portSeparator);
                        dbName = dbName.substring(0, portSeparator);
                    }
                    authority = authority.substring(0, backSlashIndex);
                    if (portSuffix != null) {
                        authority = authority + portSuffix;
                    }
                }
                9.parseAuthority(authority, builder);
                builder.withInstance(dbName);
                return builder;
            }
        }
        ,
        DEFAULT("default"){

            @Override
            Builder parse(String vendorUrl, Builder builder) {
                return this.defaultParse(vendorUrl, builder);
            }
        };

        private static final Map<String, ConnectionUrlParser> parsers;
        final String dbVendor;

        static ConnectionUrlParser getParser(String vendor) {
            ConnectionUrlParser parser = parsers.get(vendor);
            if (parser == null) {
                parser = DEFAULT;
            }
            return parser;
        }

        private ConnectionUrlParser(String dbVendor) {
            this.dbVendor = dbVendor;
        }

        abstract Builder parse(String var1, Builder var2);

        protected Builder defaultParse(String vendorUrl, Builder builder) {
            int propertiesStart = this.getPropertiesStart(vendorUrl);
            if (propertiesStart > 0) {
                vendorUrl = vendorUrl.substring(0, propertiesStart);
            }
            for (String localPrefix : this.getLocalSubProtocols()) {
                if (!vendorUrl.startsWith(localPrefix)) continue;
                return builder.withLocalAccess().withInstance(vendorUrl.substring(localPrefix.length()));
            }
            builder.withHostLocalhost();
            int authorityStart = vendorUrl.indexOf("//");
            String afterAuthority = null;
            if (authorityStart >= 0) {
                String authority = vendorUrl.substring(authorityStart + 2);
                if (authority.equals("/")) {
                    builder.withLocalAccess();
                } else {
                    int authorityEnd = authority.indexOf(47);
                    if (authorityEnd > 0) {
                        afterAuthority = authority.substring(authorityEnd + 1);
                        authority = authority.substring(0, authorityEnd);
                    }
                    ConnectionUrlParser.parseAuthority(authority, builder);
                }
            } else if (!vendorUrl.equals("/")) {
                builder.withInstance(vendorUrl);
            }
            if (afterAuthority != null) {
                int dbNameStart = afterAuthority.lastIndexOf(47);
                String dbName = afterAuthority.substring(dbNameStart + 1);
                for (String subProtocol : this.getLocalSubProtocols()) {
                    if (!dbName.startsWith(subProtocol)) continue;
                    dbName = dbName.substring(subProtocol.length());
                }
                builder.withInstance(dbName);
            }
            return builder;
        }

        protected int getPropertiesStart(String vendorUrl) {
            int propertiesStart = -1;
            for (char separator : new char[]{';', '?'}) {
                int index = vendorUrl.indexOf(separator);
                if (index <= 0) continue;
                propertiesStart = propertiesStart < 0 ? index : Math.min(propertiesStart, index);
            }
            return propertiesStart;
        }

        protected Set<String> getLocalSubProtocols() {
            return Collections.emptySet();
        }

        static void parseAuthority(String authority, Builder builder) {
            String host;
            int lastIndexOfColon;
            if (authority.isEmpty()) {
                return;
            }
            int port = -1;
            int indexOfColon = authority.indexOf(58);
            if (indexOfColon > 0 && indexOfColon != (lastIndexOfColon = authority.lastIndexOf(58))) {
                int indexOfIpv6End = authority.indexOf(93);
                indexOfColon = indexOfIpv6End > 0 && authority.length() > indexOfIpv6End + 1 ? indexOfIpv6End + 1 : -1;
            }
            if (indexOfColon > 0) {
                host = authority.substring(0, indexOfColon);
                if (authority.length() > indexOfColon + 1) {
                    port = ConnectionUrlParser.toNumericPort(authority, authority.substring(indexOfColon + 1));
                }
            } else {
                host = authority;
            }
            builder.withHost(host).withPort(port);
        }

        static int toNumericPort(String url, String portString) {
            int port = -1;
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                logger.debug("Port parsed from the connection string {} is not a number - {}", (Object)url, (Object)portString);
            }
            return port;
        }

        static void parseMySqlFlavor(String vendorUrl, Builder builder) {
            vendorUrl = vendorUrl.toLowerCase().trim();
            Pattern pattern = Pattern.compile("//([^/?]+)(.*)$");
            Matcher matcher = pattern.matcher(vendorUrl);
            if (matcher.find()) {
                int indexOfUserDetailsEnd;
                Matcher keyValueMatcher;
                String addressKey;
                String hostsPart = matcher.group(1);
                String afterHost = matcher.group(2);
                if (afterHost.startsWith("/")) {
                    int propertiesStart = afterHost.indexOf(63);
                    String db = afterHost.substring(1, propertiesStart < 0 ? afterHost.length() : propertiesStart);
                    builder.withInstance(db);
                }
                ArrayList<String> hosts = new ArrayList<String>();
                String[] parts = hostsPart.toLowerCase().trim().split(",");
                StringBuilder sb = new StringBuilder();
                for (String part : parts) {
                    if (part.lastIndexOf(41) < part.lastIndexOf(40)) {
                        sb.append(part).append(',');
                        continue;
                    }
                    boolean isWithinKeyValuePart = sb.length() > 0;
                    sb.append(part);
                    if (isWithinKeyValuePart && !part.contains(")")) {
                        sb.append(',');
                        continue;
                    }
                    hosts.add(sb.toString());
                    sb.setLength(0);
                }
                String firstHost = (String)hosts.get(0);
                int indexOfAddress = firstHost.indexOf(addressKey = "address=");
                if (indexOfAddress >= 0) {
                    String tmp = firstHost.substring(indexOfAddress + addressKey.length());
                    Matcher hostMatcher = Pattern.compile("\\s*host\\s*=\\s*([^)]+)\\s*").matcher(tmp);
                    if (hostMatcher.find()) {
                        String host = hostMatcher.group(1).trim();
                        int port = -1;
                        Matcher portMatcher = Pattern.compile("\\s*port\\s*=\\s*([^)]+)\\s*").matcher(tmp);
                        if (portMatcher.find()) {
                            port = ConnectionUrlParser.toNumericPort(vendorUrl, portMatcher.group(1).trim());
                        }
                        builder.withHost(host).withPort(port);
                        return;
                    }
                    logger.warn("Failed to parse address from a connection URL: {}", (Object)vendorUrl);
                    builder.withParsingError();
                }
                if ((keyValueMatcher = Pattern.compile("\\(([^)]+)\\)").matcher(firstHost)).find()) {
                    String keyValuePart = keyValueMatcher.group(1).trim();
                    parts = keyValuePart.split(",");
                    String host = null;
                    int port = -1;
                    for (String part : parts) {
                        String[] keyValue = part.split("=");
                        if (keyValue.length != 2) continue;
                        if (keyValue[0].trim().equals("host")) {
                            host = keyValue[1].trim();
                            continue;
                        }
                        if (!keyValue[0].trim().equals("port")) continue;
                        port = ConnectionUrlParser.toNumericPort(vendorUrl, keyValue[1].trim());
                    }
                    if (host != null) {
                        builder.withHost(host).withPort(port);
                        return;
                    }
                    logger.warn("Failed to parse address from a connection URL: {}", (Object)vendorUrl);
                    builder.withParsingError();
                    return;
                }
                int indexOfSquareBracket = firstHost.indexOf(91);
                if (!(indexOfSquareBracket < 0 || firstHost.contains("]") && firstHost.lastIndexOf(91) == indexOfSquareBracket)) {
                    firstHost = firstHost.substring(indexOfSquareBracket + 1);
                }
                if ((indexOfUserDetailsEnd = firstHost.indexOf(64)) >= 0) {
                    if (firstHost.length() > indexOfUserDetailsEnd + 1) {
                        firstHost = firstHost.substring(indexOfUserDetailsEnd + 1).trim();
                    } else {
                        return;
                    }
                }
                ConnectionUrlParser.parseAuthority(firstHost.trim(), builder);
            }
        }

        static {
            parsers = new HashMap<String, ConnectionUrlParser>();
            for (ConnectionUrlParser parser : ConnectionUrlParser.values()) {
                if (parser == DEFAULT) continue;
                parsers.put(parser.dbVendor, parser);
            }
        }
    }
}

