/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jdbc;

import co.elastic.apm.agent.db.signature.Scanner;
import co.elastic.apm.agent.db.signature.ScannerFilter;

public class JdbcFilter
implements ScannerFilter {
    private boolean inQuote = false;
    private boolean inJdbcEscape = false;
    private boolean jdbcKeyWord = false;

    @Override
    public boolean skip(Scanner s, char c) {
        switch (c) {
            case '{': {
                if (this.inQuote) break;
                this.inJdbcEscape = true;
                this.jdbcKeyWord = true;
                return true;
            }
            case 'O': 
            case 'o': {
                if (this.inQuote || !this.inJdbcEscape || !this.jdbcKeyWord || !s.isNextCharIgnoreCase('j')) break;
                s.next();
                this.jdbcKeyWord = false;
                return true;
            }
            case '}': {
                if (this.inQuote) break;
                this.inJdbcEscape = false;
                return true;
            }
            case '=': 
            case '?': {
                if (this.inQuote || !this.inJdbcEscape) break;
                return true;
            }
            case '\'': {
                this.inQuote = !this.inQuote;
            }
        }
        this.jdbcKeyWord = false;
        return false;
    }

    @Override
    public void reset() {
        this.inQuote = false;
        this.inJdbcEscape = false;
        this.jdbcKeyWord = false;
    }
}

