/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jbosslogging.correlation;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.jbosslogging.correlation.JBossLoggingCorrelationHelper;
import java.util.Collection;
import java.util.Collections;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class JBossLoggingCorrelationInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singleton("jboss-logging-correlation");
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.not(ElementMatchers.isBootstrapClassLoader()).and(CustomElementMatchers.classLoaderCanLoadClass("org.jboss.logging.JDKLogger"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("org.jboss.logging.JDKLogger").or(ElementMatchers.named("org.jboss.logging.JBossLogManagerLogger"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("doLog").or(ElementMatchers.named("doLogf"));
    }

    public static class AdviceClass {
        private static final JBossLoggingCorrelationHelper helper = new JBossLoggingCorrelationHelper();

        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static boolean addToMdc() {
            return helper.beforeLoggingEvent();
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void removeFromMdc(@Advice.Enter boolean addedToMdc) {
            helper.afterLoggingEvent(addedToMdc);
        }
    }
}

