/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jaxrs;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.jaxrs.JaxRsConfiguration;
import co.elastic.apm.agent.jaxrs.JaxRsOffsetMappingFactory;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class JaxRsTransactionNameInstrumentation
extends TracerAwareInstrumentation {
    private final Collection<String> applicationPackages;
    private final JaxRsConfiguration configuration;
    private final ElasticApmTracer tracer;

    public JaxRsTransactionNameInstrumentation(ElasticApmTracer tracer) {
        this.tracer = tracer;
        this.applicationPackages = tracer.getConfig(StacktraceConfiguration.class).getApplicationPackages();
        this.configuration = tracer.getConfig(JaxRsConfiguration.class);
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return CustomElementMatchers.isInAnyPackage(this.applicationPackages, ElementMatchers.any());
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        if (this.configuration.isEnableJaxrsAnnotationInheritance()) {
            return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.not(CustomElementMatchers.isProxy())).and(ElementMatchers.isAnnotatedWith(ElementMatchers.named(this.pathClassName())).or(ElementMatchers.hasSuperType(ElementMatchers.isAnnotatedWith(ElementMatchers.namedOneOf(this.pathClassName())))));
        }
        return ElementMatchers.isAnnotatedWith(ElementMatchers.namedOneOf(this.pathClassName()));
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.not(ElementMatchers.isBootstrapClassLoader()).and(CustomElementMatchers.classLoaderCanLoadClass(this.pathClassName()));
    }

    abstract String pathClassName();

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return CustomElementMatchers.overridesOrImplementsMethodThat(ElementMatchers.isAnnotatedWith(ElementMatchers.namedOneOf("javax.ws.rs.GET", "jakarta.ws.rs.GET").or(ElementMatchers.namedOneOf("javax.ws.rs.POST", "jakarta.ws.rs.POST")).or(ElementMatchers.namedOneOf("javax.ws.rs.PUT", "jakarta.ws.rs.PUT")).or(ElementMatchers.namedOneOf("javax.ws.rs.DELETE", "jakarta.ws.rs.DELETE")).or(ElementMatchers.namedOneOf("javax.ws.rs.PATCH", "jakarta.ws.rs.PATCH")).or(ElementMatchers.namedOneOf("javax.ws.rs.HEAD", "jakarta.ws.rs.HEAD")).or(ElementMatchers.namedOneOf("javax.ws.rs.OPTIONS", "jakarta.ws.rs.OPTIONS")))).onSuperClassesThat(CustomElementMatchers.isInAnyPackage(this.applicationPackages, ElementMatchers.any()));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singletonList("jax-rs");
    }

    @Override
    @Nullable
    public Advice.OffsetMapping.Factory<?> getOffsetMapping() {
        return new JaxRsOffsetMappingFactory(this.tracer);
    }

    static class BaseAdvice {
        private static final boolean useAnnotationValueForTransactionName = GlobalTracer.getTracerImpl().getConfig(JaxRsConfiguration.class).isUseJaxRsPathForTransactionName();

        BaseAdvice() {
        }

        protected static void setTransactionName(String signature, @Nullable String pathAnnotationValue, @Nullable String frameworkVersion) {
            Transaction transaction = TracerAwareInstrumentation.tracer.currentTransaction();
            if (transaction != null) {
                String transactionName = signature;
                if (useAnnotationValueForTransactionName && pathAnnotationValue != null) {
                    transactionName = pathAnnotationValue;
                }
                transaction.withName(transactionName, 100, false);
                transaction.setFrameworkName("JAX-RS");
                transaction.setFrameworkVersion(frameworkVersion);
            }
        }
    }
}

