/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.javalin;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class JavalinRenderInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("io.javalin.plugin.rendering.FileRenderer")).and(ElementMatchers.not(ElementMatchers.isInterface()));
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return CustomElementMatchers.classLoaderCanLoadClass("io.javalin.plugin.rendering.FileRenderer");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("render").and(ElementMatchers.takesArgument(0, ElementMatchers.named("java.lang.String"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("java.util.Map"))).and(ElementMatchers.takesArgument(2, ElementMatchers.named("io.javalin.http.Context")));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singleton("javalin");
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.javalin.JavalinRenderInstrumentation$RenderAdapterAdvice";
    }

    public static class RenderAdapterAdvice {
        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object setSpanName(@Advice.Argument(value=0) String template) {
            AbstractSpan<?> parent = TracerAwareInstrumentation.tracer.getActive();
            if (parent == null) {
                return null;
            }
            return ((Span)((Span)((Span)parent.createSpan().activate()).withType("app")).withSubtype("internal").appendToName("render ")).appendToName(template);
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onAfterExecute(@Advice.Enter @Nullable Object spanObj, @Advice.Thrown @Nullable Throwable t) {
            if (spanObj != null) {
                Span span = (Span)spanObj;
                span.deactivate();
                span.captureException(t);
                span.end();
            }
        }
    }
}

