/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.javalin;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.context.web.WebConfiguration;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.util.TransactionNameUtils;
import co.elastic.apm.agent.util.VersionUtils;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import io.javalin.http.HandlerType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class JavalinInstrumentation
extends TracerAwareInstrumentation {
    private static final Logger logger = LoggerFactory.getLogger(JavalinInstrumentation.class);
    private static final String FRAMEWORK_NAME = "Javalin";

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("io.javalin.http.Handler")).and(ElementMatchers.not(ElementMatchers.isInterface()));
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return CustomElementMatchers.classLoaderCanLoadClass("io.javalin.http.Handler");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("handle").and(ElementMatchers.takesArgument(0, ElementMatchers.named("io.javalin.http.Context")));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singleton("javalin");
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.javalin.JavalinInstrumentation$HandlerAdapterAdvice";
    }

    public static class HandlerAdapterAdvice {
        private static final WebConfiguration webConfig = GlobalTracer.requireTracerImpl().getConfig(WebConfiguration.class);
        private static final MethodHandle NOOP = MethodHandles.constant(String.class, "Non-supported Javalin version");
        @Nullable
        private static MethodHandle handlerTypeMethodHandle = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Nullable
        private static HandlerType getHandlerType(Context context) {
            if (handlerTypeMethodHandle == null) {
                Class<HandlerAdapterAdvice> clazz = HandlerAdapterAdvice.class;
                // MONITORENTER : co.elastic.apm.agent.javalin.JavalinInstrumentation$HandlerAdapterAdvice.class
                if (handlerTypeMethodHandle == null) {
                    try {
                        handlerTypeMethodHandle = MethodHandles.lookup().findVirtual(context.getClass(), "handlerType", MethodType.methodType(HandlerType.class));
                        logger.debug("This Javalin version is supported");
                    }
                    catch (NoSuchMethodException e) {
                        logger.info("The current Javalin version is not supported, only 3.13.8+ versions are supported");
                        handlerTypeMethodHandle = NOOP;
                    }
                    catch (Throwable throwable) {
                        logger.error("Cannot get a method handle for io.javalin.http.Context#handlerType(), Javalin will not be traced", throwable);
                        handlerTypeMethodHandle = NOOP;
                    }
                }
                // MONITOREXIT : clazz
            }
            HandlerType handlerType = null;
            if (handlerTypeMethodHandle == NOOP) return handlerType;
            try {
                return handlerTypeMethodHandle.invoke(context);
            }
            catch (Throwable throwable) {
                logger.error("Cannot determine Javalin HandlerType. Javalin cannot be traced");
            }
            return handlerType;
        }

        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object setSpanAndTransactionName(@Advice.This Handler handler, @Advice.Argument(value=0) Context ctx) {
            AbstractSpan<?> parent;
            StringBuilder name;
            HandlerType handlerType = HandlerAdapterAdvice.getHandlerType(ctx);
            if (handlerType == null) {
                return null;
            }
            Transaction transaction = TracerAwareInstrumentation.tracer.currentTransaction();
            if (transaction == null) {
                return null;
            }
            String handlerClassName = handler.getClass().getName();
            if (handlerClassName.startsWith("io.javalin.http.JavalinServlet")) {
                return null;
            }
            if (handlerType.isHttpMethod() && (name = transaction.getAndOverrideName(100, false)) != null) {
                transaction.setFrameworkName(JavalinInstrumentation.FRAMEWORK_NAME);
                transaction.setFrameworkVersion(VersionUtils.getVersion(Handler.class, "io.javalin", "javalin"));
                transaction.withType("request");
                TransactionNameUtils.setNameFromHttpRequestPath(handlerType.name(), ctx.endpointHandlerPath(), name, webConfig.getUrlGroups());
            }
            if ((parent = TracerAwareInstrumentation.tracer.getActive()) == null) {
                return null;
            }
            return ((Span)((Span)((Span)((Span)parent.createSpan().activate()).withType("app")).withSubtype("internal").appendToName(handlerType.name())).appendToName(" ")).appendToName(ctx.matchedPath());
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onAfterExecute(@Advice.Enter @Nullable Object spanObj, @Advice.Argument(value=0) Context ctx, @Advice.Thrown @Nullable Throwable t) {
            if (spanObj != null) {
                Span span = (Span)spanObj;
                span.deactivate();
                CompletableFuture responseFuture = ctx.resultFuture();
                if (responseFuture == null) {
                    ((Span)span.captureException(t)).end();
                } else {
                    responseFuture.whenComplete((o, futureThrowable) -> ((Span)span.captureException((Throwable)futureThrowable)).end());
                }
            }
        }
    }
}

