/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.transaction;

import java.util.Objects;
import javax.annotation.Nullable;

public class StackFrame {
    @Nullable
    private final String className;
    private final String methodName;

    public static StackFrame of(@Nullable String className, String methodName) {
        return new StackFrame(className, methodName);
    }

    public StackFrame(@Nullable String className, String methodName) {
        this.className = className;
        this.methodName = methodName;
    }

    @Nullable
    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getSimpleClassNameOffset() {
        if (this.className != null) {
            return this.className.lastIndexOf(46) + 1;
        }
        return 0;
    }

    public void appendFileName(StringBuilder replaceBuilder) {
        if (this.className != null) {
            int classNameStart;
            int fileNameEnd = this.className.indexOf(36);
            if (fileNameEnd < 0) {
                fileNameEnd = this.className.length();
            }
            if ((classNameStart = this.className.lastIndexOf(46)) < fileNameEnd && fileNameEnd <= this.className.length()) {
                replaceBuilder.append(this.className, classNameStart + 1, fileNameEnd);
                replaceBuilder.append(".java");
            } else {
                replaceBuilder.append("<Unknown>");
            }
        } else {
            replaceBuilder.append("<Unknown>");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackFrame that = (StackFrame)o;
        if (!Objects.equals(this.className, that.className)) {
            return false;
        }
        return this.methodName.equals(that.methodName);
    }

    public int hashCode() {
        int result = this.className != null ? this.className.hashCode() : 0;
        result = 31 * result + this.methodName.hashCode();
        return result;
    }

    public String toString() {
        if (this.className == null) {
            return this.methodName;
        }
        return this.className + '.' + this.methodName;
    }
}

