/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.transaction;

import co.elastic.apm.agent.impl.Scope;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.ElasticContext;
import co.elastic.apm.agent.impl.transaction.Transaction;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

public class ElasticContextWrapper<T extends ElasticContext<T>>
implements ElasticContext<T> {
    private final ElasticContext<T> context;
    private final Map<Class<?>, ElasticContext<?>> contextWrappers;

    public ElasticContextWrapper(int initialSize, ElasticContext<T> context) {
        this.contextWrappers = new HashMap(initialSize, 1.0f);
        this.context = context;
    }

    public <C extends ElasticContext<C>> C wrapIfRequired(Class<C> wrapperType, Callable<C> wrapFunction) {
        ElasticContext wrapped = this.contextWrappers.get(wrapperType);
        if (wrapped == null) {
            try {
                wrapped = (ElasticContext)Objects.requireNonNull(wrapFunction.call());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            this.contextWrappers.put(wrapperType, wrapped);
        }
        return (C)wrapped;
    }

    public ElasticContext<T> getWrappedContext() {
        return this.context;
    }

    @Override
    public T activate() {
        throw ElasticContextWrapper.activationNotSupported();
    }

    @Override
    public T deactivate() {
        throw ElasticContextWrapper.activationNotSupported();
    }

    @Override
    public Scope activateInScope() {
        throw ElasticContextWrapper.activationNotSupported();
    }

    @Override
    public ElasticContext<T> withActiveSpan(AbstractSpan<?> span) {
        throw ElasticContextWrapper.activationNotSupported();
    }

    private static UnsupportedOperationException activationNotSupported() {
        return new UnsupportedOperationException("activation not expected on context wrapper");
    }

    @Override
    @Nullable
    public AbstractSpan<?> getSpan() {
        return this.context.getSpan();
    }

    @Override
    @Nullable
    public Transaction getTransaction() {
        return this.context.getTransaction();
    }
}

