/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.transaction;

import co.elastic.apm.agent.impl.context.ServiceTarget;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.objectpool.Allocator;
import co.elastic.apm.agent.objectpool.ObjectPool;
import co.elastic.apm.agent.objectpool.Recyclable;
import co.elastic.apm.agent.objectpool.impl.QueueBasedObjectPool;
import co.elastic.apm.agent.util.CharSequenceUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.jctools.queues.atomic.MpmcAtomicArrayQueue;

public class DroppedSpanStats
implements Iterable<Map.Entry<StatsKey, Stats>>,
Recyclable {
    private static final ObjectPool<StatsKey> statsKeyObjectPool = QueueBasedObjectPool.ofRecyclable(new MpmcAtomicArrayQueue(512), false, new Allocator<StatsKey>(){

        @Override
        public StatsKey createInstance() {
            return new StatsKey();
        }
    });
    private static final ObjectPool<Stats> statsObjectPool = QueueBasedObjectPool.ofRecyclable(new MpmcAtomicArrayQueue(512), false, new Allocator<Stats>(){

        @Override
        public Stats createInstance() {
            return new Stats();
        }
    });
    private final ConcurrentMap<StatsKey, Stats> statsMap = new ConcurrentHashMap<StatsKey, Stats>();

    @Nullable
    Stats getStats(String serviceType, @Nullable String serviceName, Outcome outcome) {
        ServiceTarget st = new ServiceTarget().withType(serviceType).withName(serviceName);
        return (Stats)this.statsMap.get(new StatsKey().init(st, outcome));
    }

    public void captureDroppedSpan(Span span) {
        ServiceTarget serviceTarget = span.getContext().getServiceTarget();
        if (!span.isExit() || !serviceTarget.hasContent()) {
            return;
        }
        Stats stats = this.getOrCreateStats(serviceTarget, span.getOutcome());
        if (span.isComposite()) {
            stats.count.addAndGet(span.getComposite().getCount());
        } else {
            stats.count.incrementAndGet();
        }
        stats.sum.addAndGet(span.getDuration());
    }

    private Stats getOrCreateStats(ServiceTarget serviceTarget, Outcome outcome) {
        StatsKey statsKey = statsKeyObjectPool.createInstance().init(serviceTarget, outcome);
        Stats stats = (Stats)this.statsMap.get(statsKey);
        if (stats != null || this.statsMap.size() > 127) {
            statsKeyObjectPool.recycle(statsKey);
            return stats;
        }
        stats = statsObjectPool.createInstance();
        Stats oldStats = this.statsMap.putIfAbsent(statsKey, stats);
        if (oldStats != null) {
            statsKeyObjectPool.recycle(statsKey);
            statsObjectPool.recycle(stats);
            return oldStats;
        }
        return stats;
    }

    @Override
    public Iterator<Map.Entry<StatsKey, Stats>> iterator() {
        return this.statsMap.entrySet().iterator();
    }

    @Override
    public void resetState() {
        for (Map.Entry e : this.statsMap.entrySet()) {
            statsKeyObjectPool.recycle((StatsKey)e.getKey());
            statsObjectPool.recycle((Stats)e.getValue());
        }
        this.statsMap.clear();
    }

    public static class Stats
    implements Recyclable {
        private final AtomicInteger count = new AtomicInteger(0);
        private final AtomicLong sum = new AtomicLong(0L);

        public int getCount() {
            return this.count.get();
        }

        public long getSum() {
            return this.sum.get();
        }

        @Override
        public void resetState() {
            this.count.set(0);
            this.sum.set(0L);
        }
    }

    public static class StatsKey
    implements Recyclable {
        @Nullable
        private String serviceType;
        private final StringBuilder serviceName = new StringBuilder();
        private final StringBuilder destinationResource = new StringBuilder();
        private Outcome outcome = Outcome.UNKNOWN;
        private int cachedHashCode = Integer.MIN_VALUE;

        public StatsKey init(ServiceTarget serviceTarget, Outcome outcome) {
            this.resetState();
            this.serviceType = Objects.requireNonNull(serviceTarget.getType());
            CharSequence name = serviceTarget.getName();
            if (name != null) {
                this.serviceName.append(name);
            }
            this.destinationResource.append(Objects.requireNonNull(serviceTarget.getDestinationResource()));
            this.outcome = outcome;
            return this;
        }

        @Nullable
        public CharSequence getDestinationServiceResource() {
            return this.destinationResource;
        }

        public String getServiceType() {
            return Objects.requireNonNull(this.serviceType);
        }

        @Nullable
        public CharSequence getServiceName() {
            return this.serviceName;
        }

        public Outcome getOutcome() {
            return this.outcome;
        }

        @Override
        public void resetState() {
            this.serviceType = null;
            this.serviceName.setLength(0);
            this.destinationResource.setLength(0);
            this.outcome = Outcome.UNKNOWN;
            this.cachedHashCode = Integer.MIN_VALUE;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StatsKey statsKey = (StatsKey)o;
            if (this.serviceType != null ? !this.serviceType.equals(statsKey.serviceType) : statsKey.serviceType != null) {
                return false;
            }
            if (!CharSequenceUtils.equals(this.serviceName, statsKey.serviceName)) {
                return false;
            }
            if (!CharSequenceUtils.equals(this.destinationResource, statsKey.destinationResource)) {
                return false;
            }
            return this.outcome == statsKey.outcome;
        }

        public int hashCode() {
            if (this.cachedHashCode != Integer.MIN_VALUE) {
                return this.cachedHashCode;
            }
            int result = this.serviceType != null ? this.serviceType.hashCode() : 0;
            result = 31 * result + CharSequenceUtils.hashCode(this.serviceName);
            result = 31 * result + CharSequenceUtils.hashCode(this.destinationResource);
            this.cachedHashCode = result = 31 * result + this.outcome.hashCode();
            return result;
        }
    }
}

