/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.sampling;

import co.elastic.apm.agent.impl.sampling.ConstantSampler;
import co.elastic.apm.agent.impl.sampling.Sampler;
import co.elastic.apm.agent.impl.transaction.Id;
import co.elastic.apm.agent.impl.transaction.TraceState;

public class ProbabilitySampler
implements Sampler {
    private final long lowerBound;
    private final long higherBound;
    private final double sampleRate;
    private final String traceStateHeader;

    private ProbabilitySampler(double samplingRate) {
        this.higherBound = (long)(9.223372036854776E18 * samplingRate);
        this.lowerBound = -this.higherBound;
        this.sampleRate = samplingRate;
        this.traceStateHeader = TraceState.getHeaderValue(samplingRate);
    }

    public static Sampler of(double samplingRate) {
        if (samplingRate == 1.0) {
            return ConstantSampler.of(true);
        }
        if (samplingRate == 0.0) {
            return ConstantSampler.of(false);
        }
        return new ProbabilitySampler(samplingRate);
    }

    @Override
    public boolean isSampled(Id traceId) {
        long leastSignificantBits = traceId.getLeastSignificantBits();
        return leastSignificantBits > this.lowerBound && leastSignificantBits < this.higherBound;
    }

    @Override
    public double getSampleRate() {
        return this.sampleRate;
    }

    @Override
    public String getTraceStateHeader() {
        return this.traceStateHeader;
    }
}

