/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.metadata;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.configuration.ServerlessConfiguration;
import co.elastic.apm.agent.impl.metadata.Agent;
import co.elastic.apm.agent.impl.metadata.Language;
import co.elastic.apm.agent.impl.metadata.Node;
import co.elastic.apm.agent.impl.metadata.RuntimeInfo;
import co.elastic.apm.agent.impl.metadata.Service;
import co.elastic.apm.agent.util.PrivilegedActionUtils;
import co.elastic.apm.agent.util.VersionUtils;

public class ServiceFactory {
    public Service createService(CoreConfiguration coreConfiguration, String ephemeralId, ServerlessConfiguration serverlessConfiguration) {
        Service service = new Service().withName(coreConfiguration.getServiceName()).withVersion(coreConfiguration.getServiceVersion()).withEnvironment(coreConfiguration.getEnvironment()).withAgent(new Agent("java", VersionUtils.getAgentVersion(), ephemeralId)).withRuntime(new RuntimeInfo("Java", System.getProperty("java.version"))).withLanguage(new Language("Java", System.getProperty("java.version"))).withNode(new Node(coreConfiguration.getServiceNodeName()));
        if (serverlessConfiguration.runsOnAwsLambda()) {
            this.augmentServiceForAWSLambda(service);
        }
        return service;
    }

    private void augmentServiceForAWSLambda(Service service) {
        String serviceNodeName;
        String nodeName;
        String runtimeName = PrivilegedActionUtils.getEnv("AWS_EXECUTION_ENV");
        runtimeName = null != runtimeName ? runtimeName : "AWS_Lambda_java";
        service.withRuntime(new RuntimeInfo(runtimeName, System.getProperty("java.version")));
        Node node = service.getNode();
        String string = nodeName = node != null ? node.getName() : null;
        if ((nodeName == null || nodeName.isEmpty()) && null != (serviceNodeName = PrivilegedActionUtils.getEnv("AWS_LAMBDA_LOG_STREAM_NAME"))) {
            service.withNode(new Node(serviceNodeName));
        }
    }
}

