/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.context;

import co.elastic.apm.agent.objectpool.Recyclable;
import javax.annotation.Nullable;

public class ServiceTarget
implements Recyclable {
    @Nullable
    private String type;
    private boolean typeSetByUser;
    private boolean nameSetByUser;
    private final StringBuilder name = new StringBuilder();
    private boolean onlyNameInResource = false;
    private final StringBuilder destinationResource = new StringBuilder();

    public ServiceTarget withType(@Nullable String type) {
        if (this.typeSetByUser) {
            return this;
        }
        this.type = type;
        return this;
    }

    public ServiceTarget withUserType(@Nullable String type) {
        this.type = type;
        this.typeSetByUser = true;
        return this;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public ServiceTarget withName(@Nullable CharSequence name) {
        if (name == null || name.length() == 0 || this.nameSetByUser) {
            return this;
        }
        this.name.setLength(0);
        this.name.append(name);
        return this;
    }

    public ServiceTarget withUserName(@Nullable CharSequence name) {
        this.name.setLength(0);
        if (name != null) {
            this.name.append(name);
        }
        this.nameSetByUser = true;
        return this;
    }

    @Nullable
    public CharSequence getName() {
        return this.name.length() == 0 ? null : this.name;
    }

    public ServiceTarget withNameOnlyDestinationResource() {
        this.onlyNameInResource = true;
        return this;
    }

    public ServiceTarget withHostPortName(@Nullable CharSequence host, int port) {
        if (host == null || host.length() == 0 || this.nameSetByUser) {
            return this;
        }
        this.name.setLength(0);
        this.name.append(host);
        if (port > 0) {
            this.name.append(":").append(port);
        }
        return this;
    }

    @Override
    public void resetState() {
        this.type = null;
        this.typeSetByUser = false;
        this.name.setLength(0);
        this.nameSetByUser = false;
        this.onlyNameInResource = false;
    }

    public boolean hasContent() {
        return this.type != null || this.name.length() > 0;
    }

    @Nullable
    public CharSequence getDestinationResource() {
        if (this.name.length() == 0) {
            return this.type;
        }
        if (this.onlyNameInResource) {
            return this.name;
        }
        this.destinationResource.setLength(0);
        if (this.type != null && this.type.length() > 0) {
            this.destinationResource.append(this.type);
            this.destinationResource.append("/");
        }
        this.destinationResource.append((CharSequence)this.name);
        return this.destinationResource;
    }

    public boolean isSetByUser() {
        return this.typeSetByUser || this.nameSetByUser;
    }

    public void copyFrom(ServiceTarget other) {
        this.withType(other.type);
        this.withName(other.name);
        this.typeSetByUser = other.typeSetByUser;
        this.nameSetByUser = other.nameSetByUser;
        this.onlyNameInResource = other.onlyNameInResource;
    }
}

