/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.context;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.context.Request;
import co.elastic.apm.agent.impl.context.TransactionContext;
import co.elastic.apm.agent.impl.error.ErrorCapture;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.report.processor.Processor;
import co.elastic.apm.agent.util.PotentiallyMultiValuedMap;
import org.stagemonitor.configuration.ConfigurationRegistry;

public class SanitizingWebProcessor
implements Processor {
    private final CoreConfiguration config;

    public SanitizingWebProcessor(ConfigurationRegistry configurationRegistry) {
        this.config = configurationRegistry.getConfig(CoreConfiguration.class);
    }

    @Override
    public void processBeforeReport(Transaction transaction) {
        this.sanitizeContext(transaction.getContext());
    }

    @Override
    public void processBeforeReport(ErrorCapture error) {
        this.sanitizeContext(error.getContext());
    }

    private void sanitizeContext(TransactionContext context) {
        this.sanitizeRequest(context.getRequest());
        this.sanitizeMap(context.getResponse().getHeaders());
    }

    private void sanitizeRequest(Request request) {
        this.sanitizeMap(request.getHeaders());
        request.getHeaders().removeIgnoreCase("Cookie");
        this.sanitizeMap(request.getFormUrlEncodedParameters());
        this.sanitizeMap(request.getCookies());
    }

    private void sanitizeMap(PotentiallyMultiValuedMap map) {
        for (int i = 0; i < map.size(); ++i) {
            if (!this.isSensitive(map.getKey(i))) continue;
            map.set(i, "[REDACTED]");
        }
    }

    private boolean isSensitive(String key) {
        assert (this.config != null);
        return WildcardMatcher.anyMatch(this.config.getSanitizeFieldNames(), key) != null;
    }
}

