/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.circuitbreaker;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.circuitbreaker.StressMonitor;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.List;

class GCStressMonitor
extends StressMonitor {
    private static final Logger logger = LoggerFactory.getLogger(GCStressMonitor.class);
    private final List<MemoryPoolMXBean> heapMBeans = new ArrayList<MemoryPoolMXBean>();
    private final StringBuilder latestStressDetectionInfo = new StringBuilder("No stress has been detected so far.");

    GCStressMonitor(ElasticApmTracer tracer) {
        super(tracer);
        this.discoverMBeans();
    }

    private void discoverMBeans() {
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
            MemoryUsage collectionUsage = memoryPoolMXBean.getCollectionUsage();
            if (collectionUsage != null && !memoryPoolMXBean.getName().toLowerCase().contains("survivor")) {
                this.heapMBeans.add(memoryPoolMXBean);
                logger.debug("Registering a heap memory pool ({}) for stress monitoring", (Object)memoryPoolMXBean.getName());
                continue;
            }
            logger.trace("Ignoring a non-heap memory pool ({}) for stress monitoring", (Object)memoryPoolMXBean.getName());
        }
    }

    @Override
    boolean isUnderStress() {
        return this.isThresholdCrossed(this.circuitBreakerConfiguration.getGcStressThreshold(), true);
    }

    private boolean isThresholdCrossed(double percentageThreshold, boolean updateStressInfoIfCrossed) {
        for (int i = 0; i < this.heapMBeans.size(); ++i) {
            MemoryPoolMXBean heapPoolMBean = this.heapMBeans.get(i);
            MemoryUsage memUsageAfterLastGc = heapPoolMBean.getCollectionUsage();
            if (memUsageAfterLastGc != null) {
                long max = memUsageAfterLastGc.getMax();
                if (max <= 0L) continue;
                long bytesThreshold = (long)(percentageThreshold * (double)max);
                long used = memUsageAfterLastGc.getUsed();
                if (bytesThreshold > 0L && used > bytesThreshold) {
                    if (updateStressInfoIfCrossed) {
                        this.latestStressDetectionInfo.setLength(0);
                        this.latestStressDetectionInfo.append("Heap pool \"").append(heapPoolMBean.getName()).append("\" usage after the last GC has crossed the configured threshold ").append(percentageThreshold).append(": ").append(used).append("/").append(max).append("(used/max)");
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("Heap {} pool usage after the last GC is over the threshold of {}: {}/{} (used/max)", heapPoolMBean.getName(), percentageThreshold, used, max);
                    }
                    return true;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Heap {} pool usage after the last GC is below the threshold of {}: {}/{} (used/max)", heapPoolMBean.getName(), percentageThreshold, used, max);
                continue;
            }
            logger.debug("Collection usage cannot be obtained from heap pool MBean {}", (Object)heapPoolMBean.getName());
        }
        return false;
    }

    @Override
    boolean isStressRelieved() {
        return !this.isThresholdCrossed(this.circuitBreakerConfiguration.getGcReliefThreshold(), false);
    }

    @Override
    String getStressDetectionInfo() {
        return this.latestStressDetectionInfo.toString();
    }
}

