/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl;

import co.elastic.apm.agent.common.JvmRuntimeInfo;
import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.configuration.ServiceInfo;
import co.elastic.apm.agent.configuration.SpanConfiguration;
import co.elastic.apm.agent.context.ClosableLifecycleListenerAdapter;
import co.elastic.apm.agent.context.LifecycleListener;
import co.elastic.apm.agent.impl.ActivationListener;
import co.elastic.apm.agent.impl.ActiveStack;
import co.elastic.apm.agent.impl.Scope;
import co.elastic.apm.agent.impl.Tracer;
import co.elastic.apm.agent.impl.TracerConfiguration;
import co.elastic.apm.agent.impl.error.ErrorCapture;
import co.elastic.apm.agent.impl.metadata.MetaDataFuture;
import co.elastic.apm.agent.impl.sampling.ProbabilitySampler;
import co.elastic.apm.agent.impl.sampling.Sampler;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.BinaryHeaderGetter;
import co.elastic.apm.agent.impl.transaction.ElasticContext;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TextHeaderGetter;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.logging.LoggingConfiguration;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.metrics.MetricRegistry;
import co.elastic.apm.agent.objectpool.ObjectPool;
import co.elastic.apm.agent.objectpool.ObjectPoolFactory;
import co.elastic.apm.agent.report.ApmServerClient;
import co.elastic.apm.agent.report.Reporter;
import co.elastic.apm.agent.report.ReporterConfiguration;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakConcurrent;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import co.elastic.apm.agent.util.DependencyInjectingServiceLoader;
import co.elastic.apm.agent.util.ExecutorUtils;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nullable;
import org.stagemonitor.configuration.ConfigurationOption;
import org.stagemonitor.configuration.ConfigurationOptionProvider;
import org.stagemonitor.configuration.ConfigurationRegistry;

public class ElasticApmTracer
implements Tracer {
    private static final Logger logger = LoggerFactory.getLogger(ElasticApmTracer.class);
    private static final WeakMap<ClassLoader, ServiceInfo> serviceInfoByClassLoader = WeakConcurrent.buildMap();
    private final ConfigurationRegistry configurationRegistry;
    private final StacktraceConfiguration stacktraceConfiguration;
    private final ApmServerClient apmServerClient;
    private final List<LifecycleListener> lifecycleListeners = new CopyOnWriteArrayList<LifecycleListener>();
    private final ObjectPool<Transaction> transactionPool;
    private final ObjectPool<Span> spanPool;
    private final ObjectPool<ErrorCapture> errorPool;
    private final ObjectPool<TraceContext> spanLinkPool;
    private final Reporter reporter;
    private final ObjectPoolFactory objectPoolFactory;
    private final ThreadLocal<ActiveStack> activeStack = new ThreadLocal<ActiveStack>(){

        @Override
        protected ActiveStack initialValue() {
            return new ActiveStack(ElasticApmTracer.this.transactionMaxSpans);
        }
    };
    private final CoreConfiguration coreConfiguration;
    private final int transactionMaxSpans;
    private final SpanConfiguration spanConfiguration;
    private final List<ActivationListener> activationListeners;
    private final MetricRegistry metricRegistry;
    private final ScheduledThreadPoolExecutor sharedPool;
    private final int approximateContextSize;
    private Sampler sampler;
    boolean assertionsEnabled = false;
    private volatile Tracer.TracerState tracerState = Tracer.TracerState.UNINITIALIZED;
    private volatile boolean currentlyUnderStress = false;
    private volatile boolean recordingConfigOptionSet;
    private final String ephemeralId;
    private final MetaDataFuture metaDataFuture;

    ElasticApmTracer(ConfigurationRegistry configurationRegistry, MetricRegistry metricRegistry, Reporter reporter, ObjectPoolFactory poolFactory, ApmServerClient apmServerClient, String ephemeralId, MetaDataFuture metaDataFuture) {
        this.metricRegistry = metricRegistry;
        this.configurationRegistry = configurationRegistry;
        this.reporter = reporter;
        this.stacktraceConfiguration = configurationRegistry.getConfig(StacktraceConfiguration.class);
        this.apmServerClient = apmServerClient;
        this.ephemeralId = ephemeralId;
        this.metaDataFuture = metaDataFuture;
        int maxPooledElements = configurationRegistry.getConfig(ReporterConfiguration.class).getMaxQueueSize() * 2;
        this.coreConfiguration = configurationRegistry.getConfig(CoreConfiguration.class);
        this.transactionMaxSpans = this.coreConfiguration.getTransactionMaxSpans();
        this.spanConfiguration = configurationRegistry.getConfig(SpanConfiguration.class);
        TracerConfiguration tracerConfiguration = configurationRegistry.getConfig(TracerConfiguration.class);
        this.recordingConfigOptionSet = tracerConfiguration.getRecordingConfig().get();
        tracerConfiguration.getRecordingConfig().addChangeListener(new ConfigurationOption.ChangeListener<Boolean>(){

            @Override
            public void onChange(ConfigurationOption<?> configurationOption, Boolean oldValue, Boolean newValue) {
                ElasticApmTracer.this.recordingConfigChanged(oldValue, newValue);
            }
        });
        this.objectPoolFactory = poolFactory;
        this.transactionPool = poolFactory.createTransactionPool(maxPooledElements, this);
        this.spanPool = poolFactory.createSpanPool(maxPooledElements, this);
        this.errorPool = poolFactory.createErrorPool(maxPooledElements / 2, this);
        this.spanLinkPool = poolFactory.createSpanLinkPool(10000, this);
        this.sampler = ProbabilitySampler.of(this.coreConfiguration.getSampleRate().get());
        this.coreConfiguration.getSampleRate().addChangeListener(new ConfigurationOption.ChangeListener<Double>(){

            @Override
            public void onChange(ConfigurationOption<?> configurationOption, Double oldValue, Double newValue) {
                ElasticApmTracer.this.sampler = ProbabilitySampler.of(newValue);
            }
        });
        this.activationListeners = DependencyInjectingServiceLoader.load(ActivationListener.class, this);
        this.sharedPool = ExecutorUtils.createSingleThreadSchedulingDaemonPool("shared");
        this.approximateContextSize = this.coreConfiguration.getExternalPluginsCount() + 1;
        if (!$assertionsDisabled) {
            this.assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
    }

    @Override
    @Nullable
    public Transaction startRootTransaction(@Nullable ClassLoader initiatingClassLoader) {
        return this.startRootTransaction(this.sampler, -1L, initiatingClassLoader);
    }

    @Override
    @Nullable
    public Transaction startRootTransaction(@Nullable ClassLoader initiatingClassLoader, long epochMicro) {
        return this.startRootTransaction(this.sampler, epochMicro, initiatingClassLoader);
    }

    @Override
    @Nullable
    public Transaction startRootTransaction(Sampler sampler, long epochMicros, @Nullable ClassLoader initiatingClassLoader) {
        Transaction transaction = null;
        if (this.isRunning()) {
            transaction = this.createTransaction().startRoot(epochMicros, sampler);
            this.afterTransactionStart(initiatingClassLoader, transaction);
        }
        return transaction;
    }

    @Override
    @Nullable
    public <C> Transaction startChildTransaction(@Nullable C headerCarrier, TextHeaderGetter<C> textHeadersGetter, @Nullable ClassLoader initiatingClassLoader) {
        return this.startChildTransaction(headerCarrier, textHeadersGetter, this.sampler, -1L, initiatingClassLoader);
    }

    @Override
    @Nullable
    public <C> Transaction startChildTransaction(@Nullable C headerCarrier, TextHeaderGetter<C> textHeadersGetter, @Nullable ClassLoader initiatingClassLoader, long epochMicros) {
        return this.startChildTransaction(headerCarrier, textHeadersGetter, this.sampler, epochMicros, initiatingClassLoader);
    }

    @Override
    @Nullable
    public <C> Transaction startChildTransaction(@Nullable C headerCarrier, TextHeaderGetter<C> textHeadersGetter, Sampler sampler, long epochMicros, @Nullable ClassLoader initiatingClassLoader) {
        Transaction transaction = null;
        if (this.isRunning()) {
            transaction = this.createTransaction().start(TraceContext.getFromTraceContextTextHeaders(), headerCarrier, textHeadersGetter, epochMicros, sampler);
            this.afterTransactionStart(initiatingClassLoader, transaction);
        }
        return transaction;
    }

    @Override
    @Nullable
    public <C> Transaction startChildTransaction(@Nullable C headerCarrier, BinaryHeaderGetter<C> binaryHeadersGetter, @Nullable ClassLoader initiatingClassLoader) {
        return this.startChildTransaction(headerCarrier, binaryHeadersGetter, this.sampler, -1L, initiatingClassLoader);
    }

    @Override
    @Nullable
    public <C> Transaction startChildTransaction(@Nullable C headerCarrier, BinaryHeaderGetter<C> binaryHeadersGetter, Sampler sampler, long epochMicros, @Nullable ClassLoader initiatingClassLoader) {
        Transaction transaction = null;
        if (this.isRunning()) {
            transaction = this.createTransaction().start(TraceContext.getFromTraceContextBinaryHeaders(), headerCarrier, binaryHeadersGetter, epochMicros, sampler);
            this.afterTransactionStart(initiatingClassLoader, transaction);
        }
        return transaction;
    }

    private void afterTransactionStart(@Nullable ClassLoader initiatingClassLoader, Transaction transaction) {
        ServiceInfo serviceInfo;
        if (logger.isDebugEnabled()) {
            logger.debug("startTransaction {}", (Object)transaction);
            if (logger.isTraceEnabled()) {
                logger.trace("starting transaction at", new RuntimeException("this exception is just used to record where the transaction has been started from"));
            }
        }
        if ((serviceInfo = this.getServiceInfoForClassLoader(initiatingClassLoader)) != null) {
            transaction.getTraceContext().setServiceInfo(serviceInfo.getServiceName(), serviceInfo.getServiceVersion());
        }
    }

    public Transaction noopTransaction() {
        return this.createTransaction().startNoop();
    }

    private Transaction createTransaction() {
        Transaction transaction = this.transactionPool.createInstance();
        while (transaction.getReferenceCount() != 0) {
            logger.warn("Tried to start a transaction with a non-zero reference count {} {}", (Object)transaction.getReferenceCount(), (Object)transaction);
            transaction = this.transactionPool.createInstance();
        }
        return transaction;
    }

    @Override
    @Nullable
    public Transaction currentTransaction() {
        return this.activeStack.get().currentTransaction();
    }

    public <T> Span startSpan(TraceContext.ChildContextCreator<T> childContextCreator, T parentContext) {
        return this.startSpan(childContextCreator, parentContext, -1L);
    }

    public Span startSpan(AbstractSpan<?> parent, long epochMicros) {
        return this.startSpan(TraceContext.fromParent(), parent, epochMicros);
    }

    public <T> Span startSpan(TraceContext.ChildContextCreator<T> childContextCreator, T parentContext, long epochMicros) {
        return this.createSpan().start(childContextCreator, parentContext, epochMicros);
    }

    private Span createSpan() {
        Span span = this.spanPool.createInstance();
        while (span.getReferenceCount() != 0) {
            logger.warn("Tried to start a span with a non-zero reference count {} {}", (Object)span.getReferenceCount(), (Object)span);
            span = this.spanPool.createInstance();
        }
        return span;
    }

    @Override
    public void captureAndReportException(@Nullable Throwable e, ClassLoader initiatingClassLoader) {
        ErrorCapture errorCapture = this.captureException(System.currentTimeMillis() * 1000L, e, this.getActive(), initiatingClassLoader);
        if (errorCapture != null) {
            errorCapture.end();
        }
    }

    @Override
    @Nullable
    public String captureAndReportException(long epochMicros, @Nullable Throwable e, @Nullable AbstractSpan<?> parent) {
        String id = null;
        ErrorCapture errorCapture = this.captureException(epochMicros, e, parent, null);
        if (errorCapture != null) {
            id = errorCapture.getTraceContext().getId().toString();
            errorCapture.end();
        }
        return id;
    }

    @Override
    @Nullable
    public ErrorCapture captureException(@Nullable Throwable e, @Nullable AbstractSpan<?> parent, @Nullable ClassLoader initiatingClassLoader) {
        return this.captureException(System.currentTimeMillis() * 1000L, e, parent, initiatingClassLoader);
    }

    @Nullable
    private ErrorCapture captureException(long epochMicros, @Nullable Throwable e, @Nullable AbstractSpan<?> parent, @Nullable ClassLoader initiatingClassLoader) {
        if (!this.isRunning()) {
            return null;
        }
        if (e != null && !WildcardMatcher.isAnyMatch(this.coreConfiguration.getIgnoreExceptions(), e.getClass().getName())) {
            ErrorCapture error = this.errorPool.createInstance();
            error.withTimestamp(epochMicros);
            error.setException(e);
            Transaction currentTransaction = this.currentTransaction();
            if (currentTransaction != null) {
                if (currentTransaction.getNameForSerialization().length() > 0) {
                    error.setTransactionName(currentTransaction.getNameForSerialization());
                }
                error.setTransactionType(currentTransaction.getType());
                error.setTransactionSampled(currentTransaction.isSampled());
            }
            if (parent != null) {
                error.asChildOf(parent);
                parent.setNonDiscardable();
            } else {
                error.getTraceContext().getId().setToRandomValue();
                ServiceInfo serviceInfo = this.getServiceInfoForClassLoader(initiatingClassLoader);
                if (serviceInfo != null) {
                    error.getTraceContext().setServiceInfo(serviceInfo.getServiceName(), serviceInfo.getServiceVersion());
                }
            }
            return error;
        }
        return null;
    }

    public ConfigurationRegistry getConfigurationRegistry() {
        return this.configurationRegistry;
    }

    public <T extends ConfigurationOptionProvider> T getConfig(Class<T> configProvider) {
        return this.configurationRegistry.getConfig(configProvider);
    }

    public void endTransaction(Transaction transaction) {
        if (logger.isDebugEnabled()) {
            logger.debug("endTransaction {}", (Object)transaction);
            if (logger.isTraceEnabled()) {
                logger.trace("ending transaction at", new RuntimeException("this exception is just used to record where the transaction has been ended from"));
            }
        }
        if (!transaction.isNoop() && (transaction.isSampled() || this.apmServerClient.supportsKeepingUnsampledTransaction())) {
            this.reporter.report(transaction);
        } else {
            transaction.decrementReferences();
        }
    }

    public void endSpan(Span span) {
        if (logger.isDebugEnabled()) {
            logger.debug("endSpan {}", (Object)span);
            if (logger.isTraceEnabled()) {
                logger.trace("ending span at", new RuntimeException("this exception is just used to record where the span has been ended from"));
            }
        }
        if (!span.isSampled()) {
            Transaction transaction = span.getTransaction();
            if (transaction != null) {
                transaction.captureDroppedSpan(span);
            }
            span.decrementReferences();
            return;
        }
        if (span.isExit()) {
            if (span.getDuration() < this.spanConfiguration.getExitSpanMinDuration().getMicros()) {
                logger.debug("Span faster than exit_span_min_duration. Request discarding {}", (Object)span);
                span.requestDiscarding();
            }
        } else if (!span.isComposite() && span.getDuration() < this.coreConfiguration.getSpanMinDuration().getMicros()) {
            logger.debug("Span faster than span_min_duration. Request discarding {}", (Object)span);
            span.requestDiscarding();
        }
        if (span.isDiscarded()) {
            logger.debug("Discarding span {}", (Object)span);
            Transaction transaction = span.getTransaction();
            if (transaction != null) {
                transaction.captureDroppedSpan(span);
            }
            span.decrementReferences();
            return;
        }
        this.reportSpan(span);
    }

    private void reportSpan(Span span) {
        Transaction transaction;
        AbstractSpan<?> parent = span.getParent();
        if (parent != null && parent.isDiscarded()) {
            logger.warn("Reporting a child of an discarded span. The current span '{}' will not be shown in the UI. Consider deactivating span_min_duration.", (Object)span);
        }
        if ((transaction = span.getTransaction()) != null) {
            transaction.getSpanCount().getReported().incrementAndGet();
        }
        span.setNonDiscardable();
        long spanStackTraceMinDurationMs = this.stacktraceConfiguration.getSpanStackTraceMinDurationMs();
        if (spanStackTraceMinDurationMs >= 0L && span.isSampled() && span.getStackFrames() == null && span.getDurationMs() >= (double)spanStackTraceMinDurationMs) {
            span.withStacktrace(new Throwable());
        }
        this.reporter.report(span);
    }

    public void endError(ErrorCapture error) {
        this.reporter.report(error);
    }

    public TraceContext createSpanLink() {
        return this.spanLinkPool.createInstance();
    }

    public void recycle(Transaction transaction) {
        this.transactionPool.recycle(transaction);
    }

    public void recycle(Span span) {
        this.spanPool.recycle(span);
    }

    public void recycle(ErrorCapture error) {
        this.errorPool.recycle(error);
    }

    public void recycle(TraceContext traceContext) {
        this.spanLinkPool.recycle(traceContext);
    }

    @Override
    public synchronized void stop() {
        if (this.tracerState == Tracer.TracerState.STOPPED) {
            return;
        }
        for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
            try {
                lifecycleListener.stop();
            }
            catch (Exception e) {
                logger.warn("Suppressed exception while calling stop()", e);
            }
        }
        ExecutorUtils.shutdownAndWaitTermination(this.sharedPool);
        this.tracerState = Tracer.TracerState.STOPPED;
        logger.info("Tracer switched to STOPPED state");
        if (logger.isDebugEnabled()) {
            logger.debug("Tracer stop stack trace: ", new Throwable("Expected - for debugging purposes"));
        }
        try {
            this.configurationRegistry.close();
            this.reporter.close();
        }
        catch (Exception e) {
            logger.warn("Suppressed exception while calling stop()", e);
        }
        LoggingConfiguration.shutdown();
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    public Sampler getSampler() {
        return this.sampler;
    }

    public ObjectPoolFactory getObjectPoolFactory() {
        return this.objectPoolFactory;
    }

    @Override
    @Nullable
    public AbstractSpan<?> getActive() {
        ElasticContext<?> active = this.currentContext();
        return active != null ? active.getSpan() : null;
    }

    @Override
    @Nullable
    public Span getActiveSpan() {
        AbstractSpan<?> active = this.getActive();
        if (active instanceof Span) {
            return (Span)active;
        }
        return null;
    }

    @Override
    @Nullable
    public Span getActiveExitSpan() {
        Span span = this.getActiveSpan();
        if (span != null && span.isExit()) {
            return span;
        }
        return null;
    }

    public void registerSpanListener(ActivationListener activationListener) {
        this.activationListeners.add(activationListener);
    }

    public List<ActivationListener> getActivationListeners() {
        return this.activationListeners;
    }

    void init(List<LifecycleListener> lifecycleListeners) {
        this.lifecycleListeners.addAll(lifecycleListeners);
        for (LifecycleListener lifecycleListener : lifecycleListeners) {
            try {
                lifecycleListener.init(this);
            }
            catch (Exception e) {
                logger.error("Failed to init " + lifecycleListener.getClass().getName(), e);
            }
        }
    }

    public synchronized void start(boolean premain) {
        long delayInitMs = this.getConfig(CoreConfiguration.class).getDelayTracerStartMs();
        if (premain && this.shouldDelayOnPremain()) {
            delayInitMs = Math.max(delayInitMs, 5000L);
        }
        if (delayInitMs > 0L) {
            this.startWithDelay(delayInitMs);
        } else {
            this.startSync();
        }
    }

    private boolean shouldDelayOnPremain() {
        return JvmRuntimeInfo.ofCurrentVM().getMajorVersion() <= 8 && ClassLoader.getSystemClassLoader().getResource("org/apache/catalina/startup/Bootstrap.class") != null;
    }

    private synchronized void startWithDelay(final long delayInitMs) {
        ThreadPoolExecutor pool = ExecutorUtils.createSingleThreadDaemonPool("tracer-initializer", 1);
        pool.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info("Delaying initialization of tracer for " + delayInitMs + "ms");
                    Thread.sleep(delayInitMs);
                    logger.info("end wait");
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), e);
                }
                finally {
                    ElasticApmTracer.this.startSync();
                }
            }
        });
        pool.shutdown();
    }

    private synchronized void startSync() {
        if (this.tracerState != Tracer.TracerState.UNINITIALIZED) {
            logger.warn("Trying to start an already initialized agent");
            return;
        }
        this.apmServerClient.start();
        this.reporter.start();
        for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
            try {
                lifecycleListener.start(this);
            }
            catch (Exception e) {
                logger.error("Failed to start " + lifecycleListener.getClass().getName(), e);
            }
        }
        this.tracerState = Tracer.TracerState.RUNNING;
        if (this.recordingConfigOptionSet) {
            logger.info("Tracer switched to RUNNING state");
        } else {
            this.pause();
        }
    }

    public synchronized void onStressDetected() {
        this.currentlyUnderStress = true;
        if (this.tracerState == Tracer.TracerState.RUNNING) {
            this.pause();
        }
    }

    public synchronized void onStressRelieved() {
        this.currentlyUnderStress = false;
        if (this.tracerState == Tracer.TracerState.PAUSED && this.recordingConfigOptionSet) {
            this.resume();
        }
    }

    private synchronized void recordingConfigChanged(boolean oldValue, boolean newValue) {
        if (oldValue && !newValue && this.tracerState == Tracer.TracerState.RUNNING) {
            this.pause();
        } else if (!oldValue && newValue && this.tracerState == Tracer.TracerState.PAUSED && !this.currentlyUnderStress) {
            this.resume();
        }
        this.recordingConfigOptionSet = newValue;
    }

    synchronized void pause() {
        if (this.tracerState != Tracer.TracerState.RUNNING) {
            logger.warn("Attempting to pause the agent when it is already in a {} state", (Object)this.tracerState);
            return;
        }
        this.tracerState = Tracer.TracerState.PAUSED;
        logger.info("Tracer switched to PAUSED state");
        for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
            try {
                lifecycleListener.pause();
            }
            catch (Exception e) {
                logger.warn("Suppressed exception while calling pause()", e);
            }
        }
    }

    synchronized void resume() {
        if (this.tracerState != Tracer.TracerState.PAUSED) {
            logger.warn("Attempting to resume the agent when it is in a {} state", (Object)this.tracerState);
            return;
        }
        for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
            try {
                lifecycleListener.resume();
            }
            catch (Exception e) {
                logger.warn("Suppressed exception while calling resume()", e);
            }
        }
        this.tracerState = Tracer.TracerState.RUNNING;
        logger.info("Tracer switched to RUNNING state");
    }

    @Override
    public boolean isRunning() {
        return this.tracerState == Tracer.TracerState.RUNNING;
    }

    @Override
    @Nullable
    public Span createExitChildSpan() {
        AbstractSpan<?> active = this.getActive();
        if (active == null) {
            return null;
        }
        return active.createExitSpan();
    }

    @Override
    public Tracer.TracerState getState() {
        return this.tracerState;
    }

    @Nullable
    public <T> T getLifecycleListener(Class<T> listenerClass) {
        for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
            if (!listenerClass.isInstance(lifecycleListener)) continue;
            return (T)lifecycleListener;
        }
        return null;
    }

    @Nullable
    public ElasticContext<?> currentContext() {
        return this.activeStack.get().currentContext();
    }

    public <T extends ElasticContext<T>> T wrapActiveContextIfRequired(Class<T> wrapperClass, Callable<T> wrapFunction) {
        return this.activeStack.get().wrapActiveContextIfRequired(wrapperClass, wrapFunction, this.approximateContextSize);
    }

    public void activate(ElasticContext<?> context) {
        this.activeStack.get().activate(context, this.activationListeners);
    }

    public Scope activateInScope(final ElasticContext<?> context) {
        if (this.currentContext() == context) {
            return Scope.NoopScope.INSTANCE;
        }
        context.activate();
        if (context instanceof Scope) {
            return (Scope)((Object)context);
        }
        return new Scope(){

            @Override
            public void close() {
                context.deactivate();
            }
        };
    }

    public void deactivate(ElasticContext<?> context) {
        this.activeStack.get().deactivate(context, this.activationListeners, this.assertionsEnabled);
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public List<ServiceInfo> getServiceInfoOverrides() {
        ArrayList<ServiceInfo> serviceInfos = new ArrayList<ServiceInfo>(serviceInfoByClassLoader.approximateSize());
        for (Map.Entry entry : serviceInfoByClassLoader) {
            serviceInfos.add((ServiceInfo)entry.getValue());
        }
        return serviceInfos;
    }

    @Override
    public void setServiceInfoForClassLoader(@Nullable ClassLoader classLoader, ServiceInfo serviceInfo) {
        if (classLoader == null || !serviceInfo.hasServiceName() || this.coreConfiguration.getServiceNameConfig().getUsedKey() != null) {
            return;
        }
        logger.debug("Using `{}` as the service name and `{}` as the service version for class loader [{}]", serviceInfo.getServiceName(), serviceInfo.getServiceVersion(), classLoader);
        if (!serviceInfoByClassLoader.containsKey(classLoader)) {
            serviceInfoByClassLoader.putIfAbsent(classLoader, serviceInfo);
        }
    }

    @Override
    @Nullable
    public ServiceInfo getServiceInfoForClassLoader(@Nullable ClassLoader initiatingClassLoader) {
        if (initiatingClassLoader == null) {
            return null;
        }
        return serviceInfoByClassLoader.get(initiatingClassLoader);
    }

    public void resetServiceInfoOverrides() {
        serviceInfoByClassLoader.clear();
    }

    public ApmServerClient getApmServerClient() {
        return this.apmServerClient;
    }

    public String getEphemeralId() {
        return this.ephemeralId;
    }

    public MetaDataFuture getMetaDataFuture() {
        return this.metaDataFuture;
    }

    public ScheduledThreadPoolExecutor getSharedSingleThreadedPool() {
        return this.sharedPool;
    }

    public void addShutdownHook(Closeable closeable) {
        this.lifecycleListeners.add(ClosableLifecycleListenerAdapter.of(closeable));
    }
}

