/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl;

import co.elastic.apm.agent.impl.ActivationListener;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.ElasticContext;
import co.elastic.apm.agent.impl.transaction.ElasticContextWrapper;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

class ActiveStack {
    private static final Logger logger = LoggerFactory.getLogger(ActiveStack.class);
    private final int stackMaxDepth;
    private long overflowCounter = 0L;
    private final Deque<ElasticContext<?>> activeContextStack = new ArrayDeque();

    ActiveStack(int stackMaxDepth) {
        this.stackMaxDepth = stackMaxDepth;
    }

    @Nullable
    Transaction currentTransaction() {
        ElasticContext<?> bottomOfStack = this.activeContextStack.peekLast();
        return bottomOfStack != null ? bottomOfStack.getTransaction() : null;
    }

    @Nullable
    public ElasticContext<?> currentContext() {
        ElasticContext<?> current = this.activeContextStack.peek();
        if (current instanceof ElasticContextWrapper) {
            return ((ElasticContextWrapper)current).getWrappedContext();
        }
        return current;
    }

    boolean activate(ElasticContext<?> context, List<ActivationListener> activationListeners) {
        if (logger.isDebugEnabled()) {
            logger.debug("Activating {} on thread {}", (Object)context, (Object)Thread.currentThread().getId());
        }
        if (this.activeContextStack.size() == this.stackMaxDepth) {
            if (this.overflowCounter == 0L) {
                logger.error(String.format("Activation stack depth reached its maximum - %s. This is likely related to activation leak. Current transaction: %s", this.stackMaxDepth, this.currentTransaction()), new Throwable("Stack of threshold-crossing activation: "));
            }
            ++this.overflowCounter;
            return false;
        }
        AbstractSpan<?> span = context.getSpan();
        if (span != null) {
            span.incrementReferences();
            this.triggerActivationListeners(span, true, activationListeners);
        }
        this.activeContextStack.push(context);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean deactivate(ElasticContext<?> context, List<ActivationListener> activationListeners, boolean assertionsEnabled) {
        if (logger.isDebugEnabled()) {
            logger.debug("Deactivating {} on thread {}", (Object)context, (Object)Thread.currentThread().getId());
        }
        if (this.overflowCounter > 0L) {
            --this.overflowCounter;
            return false;
        }
        ElasticContext<Object> activeContext = this.currentContext();
        this.activeContextStack.remove();
        AbstractSpan<?> span = context.getSpan();
        if (activeContext != context && activeContext instanceof ElasticContextWrapper) {
            activeContext = ((ElasticContextWrapper)activeContext).getWrappedContext();
        }
        try {
            this.assertIsActive(context, activeContext, assertionsEnabled);
            if (null != span) {
                this.triggerActivationListeners(span, false, activationListeners);
            }
        }
        finally {
            if (null != span) {
                span.decrementReferences();
            }
        }
        return true;
    }

    private void triggerActivationListeners(AbstractSpan<?> span, boolean isActivate, List<ActivationListener> activationListeners) {
        int size = activationListeners.size();
        for (int i = 0; i < size; ++i) {
            ActivationListener listener = activationListeners.get(i);
            try {
                if (isActivate) {
                    listener.beforeActivate(span);
                    continue;
                }
                listener.afterDeactivate(span);
                continue;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                logger.warn("Exception while calling {}#{}", listener.getClass().getSimpleName(), isActivate ? "beforeActivate" : "afterDeactivate", t);
            }
        }
    }

    private void assertIsActive(ElasticContext<?> context, @Nullable ElasticContext<?> currentlyActive, boolean assertionsEnabled) {
        if (context != currentlyActive) {
            logger.warn("Deactivating a context ({}) which is not the currently active one ({}). This can happen when not properly deactivating a previous span or context.", (Object)context, (Object)currentlyActive);
            if (assertionsEnabled) {
                throw new AssertionError((Object)"Deactivating a context that is not the active one");
            }
        }
    }

    <T extends ElasticContext<T>> T wrapActiveContextIfRequired(Class<T> wrapperClass, Callable<T> wrapFunction, int approximateContextSize) {
        ElasticContext<?> current = this.activeContextStack.peek();
        Objects.requireNonNull(current, "active context required for wrapping");
        ElasticContextWrapper wrapper = current instanceof ElasticContextWrapper ? (ElasticContextWrapper)current : new ElasticContextWrapper(approximateContextSize, current);
        T wrapped = wrapper.wrapIfRequired(wrapperClass, wrapFunction);
        this.activeContextStack.remove();
        this.activeContextStack.push(wrapper);
        return wrapped;
    }
}

