/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.httpserver;

import co.elastic.apm.agent.httpserver.HttpHandlerHelper;
import co.elastic.apm.agent.httpserver.JdkHttpServerInstrumentation;
import com.sun.net.httpserver.HttpContext;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class HttpServerInstrumentation
extends JdkHttpServerInstrumentation {
    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameStartsWith("sun.net.httpserver").and(ElementMatchers.nameContains("ServerImpl"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("com.sun.net.httpserver.HttpServer"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("createContext").and(ElementMatchers.returns(ElementMatchers.hasSuperType(ElementMatchers.named("com.sun.net.httpserver.HttpContext"))));
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.httpserver.HttpServerInstrumentation$HttpServerAdvice";
    }

    public static class HttpServerAdvice {
        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onExit(@Advice.Return @Nullable HttpContext returnValue) {
            if (returnValue == null) {
                return;
            }
            HttpHandlerHelper.ensureInstrumented(returnValue.getHandler());
        }
    }
}

