/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.httpserver;

import co.elastic.apm.agent.impl.context.web.WebConfiguration;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import javax.annotation.Nullable;

public class HttpServerHelper {
    private static final Logger logger = LoggerFactory.getLogger(HttpServerHelper.class);
    private final WebConfiguration configuration;

    public HttpServerHelper(WebConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isRequestExcluded(String path, @Nullable String userAgentHeader) {
        boolean isExcluded;
        WildcardMatcher excludeAgentMatcher;
        WildcardMatcher excludeUrlMatcher = WildcardMatcher.anyMatch(this.configuration.getIgnoreUrls(), path);
        if (excludeUrlMatcher != null && logger.isDebugEnabled()) {
            logger.debug("Not tracing this request as the path {} is ignored by the matcher {}", (Object)path, (Object)excludeUrlMatcher);
        }
        WildcardMatcher wildcardMatcher = excludeAgentMatcher = userAgentHeader != null ? WildcardMatcher.anyMatch(this.configuration.getIgnoreUserAgents(), userAgentHeader) : null;
        if (excludeAgentMatcher != null) {
            logger.debug("Not tracing this request as the User-Agent {} is ignored by the matcher {}", (Object)userAgentHeader, (Object)excludeAgentMatcher);
        }
        boolean bl = isExcluded = excludeUrlMatcher != null || excludeAgentMatcher != null;
        if (!isExcluded && logger.isTraceEnabled()) {
            logger.trace("No matcher found for excluding this request with path: {} and User-Agent: {}", (Object)path, (Object)userAgentHeader);
        }
        return isExcluded;
    }
}

