/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.httpclient.v4.helper;

import co.elastic.apm.agent.httpclient.HttpClientHelper;
import co.elastic.apm.agent.httpclient.v4.helper.ApacheHttpAsyncClientHelper;
import co.elastic.apm.agent.httpclient.v4.helper.RequestHeaderAccessor;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.objectpool.Recyclable;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.RequestLine;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.protocol.HttpContext;

class HttpAsyncRequestProducerWrapper
implements HttpAsyncRequestProducer,
Recyclable {
    private final ApacheHttpAsyncClientHelper asyncClientHelper;
    private volatile HttpAsyncRequestProducer delegate;
    @Nullable
    private AbstractSpan<?> parent;
    @Nullable
    private Span span;

    HttpAsyncRequestProducerWrapper(ApacheHttpAsyncClientHelper helper) {
        this.asyncClientHelper = helper;
    }

    public HttpAsyncRequestProducerWrapper with(HttpAsyncRequestProducer delegate, @Nullable Span span, @Nullable AbstractSpan<?> parent) {
        this.span = span;
        if (parent != null) {
            parent.incrementReferences();
            this.parent = parent;
        }
        this.delegate = delegate;
        return this;
    }

    public HttpHost getTarget() {
        return this.delegate.getTarget();
    }

    public HttpRequest generateRequest() throws IOException, HttpException {
        String hostname;
        HttpHost host;
        HttpRequest request = this.delegate.generateRequest();
        if (request != null) {
            RequestLine requestLine;
            if (this.span != null && (requestLine = request.getRequestLine()) != null) {
                String method = requestLine.getMethod();
                ((Span)this.span.withName(method)).appendToName(" ");
                this.span.getContext().getHttp().withMethod(method).withUrl(requestLine.getUri());
            }
            if (!TraceContext.containsTraceContextTextHeaders(request, RequestHeaderAccessor.INSTANCE)) {
                if (this.span != null) {
                    this.span.propagateTraceContext(request, RequestHeaderAccessor.INSTANCE);
                } else if (this.parent != null) {
                    this.parent.propagateTraceContext(request, RequestHeaderAccessor.INSTANCE);
                }
            }
        }
        if (this.parent != null) {
            this.parent.decrementReferences();
            this.parent = null;
        }
        if (this.span != null && (host = this.getTarget()) != null && (hostname = host.getHostName()) != null) {
            this.span.appendToName(hostname);
            HttpClientHelper.setDestinationServiceDetails(this.span, host.getSchemeName(), hostname, host.getPort());
        }
        return request;
    }

    public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        this.delegate.produceContent(encoder, ioctrl);
    }

    public void requestCompleted(HttpContext context) {
        this.delegate.requestCompleted(context);
    }

    public void failed(Exception ex) {
        this.delegate.failed(ex);
    }

    public boolean isRepeatable() {
        return this.delegate.isRepeatable();
    }

    public void resetRequest() throws IOException {
        this.delegate.resetRequest();
    }

    public void close() throws IOException {
        this.delegate.close();
        this.asyncClientHelper.recycle(this);
    }

    @Override
    public void resetState() {
        this.span = null;
        if (this.parent != null) {
            this.parent.decrementReferences();
            this.parent = null;
        }
        this.delegate = null;
    }
}

