/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.httpclient.v4.helper;

import co.elastic.apm.agent.httpclient.v4.helper.FutureCallbackWrapper;
import co.elastic.apm.agent.httpclient.v4.helper.HttpAsyncRequestProducerWrapper;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.objectpool.Allocator;
import co.elastic.apm.agent.objectpool.ObjectPool;
import co.elastic.apm.agent.objectpool.ObjectPoolFactory;
import javax.annotation.Nullable;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.protocol.HttpContext;

public class ApacheHttpAsyncClientHelper {
    private static final int MAX_POOLED_ELEMENTS = 256;
    private final ObjectPool<HttpAsyncRequestProducerWrapper> requestProducerWrapperObjectPool;
    private final ObjectPool<FutureCallbackWrapper<?>> futureCallbackWrapperObjectPool;

    public ApacheHttpAsyncClientHelper() {
        ObjectPoolFactory factory = GlobalTracer.requireTracerImpl().getObjectPoolFactory();
        this.requestProducerWrapperObjectPool = factory.createRecyclableObjectPool(256, new RequestProducerWrapperAllocator());
        this.futureCallbackWrapperObjectPool = factory.createRecyclableObjectPool(256, new FutureCallbackWrapperAllocator());
    }

    public HttpAsyncRequestProducer wrapRequestProducer(HttpAsyncRequestProducer requestProducer, @Nullable Span span, @Nullable AbstractSpan<?> parent) {
        return this.requestProducerWrapperObjectPool.createInstance().with(requestProducer, span, parent);
    }

    public <T> FutureCallback<T> wrapFutureCallback(FutureCallback<T> futureCallback, HttpContext context, Span span) {
        return this.futureCallbackWrapperObjectPool.createInstance().with(futureCallback, context, span);
    }

    void recycle(HttpAsyncRequestProducerWrapper requestProducerWrapper) {
        this.requestProducerWrapperObjectPool.recycle(requestProducerWrapper);
    }

    void recycle(FutureCallbackWrapper<?> futureCallbackWrapper) {
        this.futureCallbackWrapperObjectPool.recycle(futureCallbackWrapper);
    }

    private class FutureCallbackWrapperAllocator
    implements Allocator<FutureCallbackWrapper<?>> {
        private FutureCallbackWrapperAllocator() {
        }

        @Override
        public FutureCallbackWrapper<?> createInstance() {
            return new FutureCallbackWrapper(ApacheHttpAsyncClientHelper.this);
        }
    }

    private class RequestProducerWrapperAllocator
    implements Allocator<HttpAsyncRequestProducerWrapper> {
        private RequestProducerWrapperAllocator() {
        }

        @Override
        public HttpAsyncRequestProducerWrapper createInstance() {
            return new HttpAsyncRequestProducerWrapper(ApacheHttpAsyncClientHelper.this);
        }
    }
}

