/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.httpclient.v4;

import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.httpclient.v4.BaseApacheHttpClientInstrumentation;
import co.elastic.apm.agent.httpclient.v4.helper.RequestHeaderAccessor;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import java.security.ProtectionDomain;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.http.HttpRequest;

public class ApacheHttpAsyncClientRedirectInstrumentation
extends BaseApacheHttpClientInstrumentation {
    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.httpclient.v4.ApacheHttpAsyncClientRedirectInstrumentation$ApacheHttpAsyncClientRedirectAdvice";
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("RedirectStrategy");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.http.client.RedirectStrategy"));
    }

    @Override
    public ElementMatcher.Junction<ProtectionDomain> getProtectionDomainPostFilter() {
        return CustomElementMatchers.implementationVersionLte("4.3.2");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("getRedirect");
    }

    public static class ApacheHttpAsyncClientRedirectAdvice {
        @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
        public static void onAfterExecute(@Advice.Argument(value=0) HttpRequest original, @Advice.Return(typing=Assigner.Typing.DYNAMIC) @Nullable HttpRequest redirect) {
            if (redirect == null) {
                return;
            }
            if (TraceContext.containsTraceContextTextHeaders(original, RequestHeaderAccessor.INSTANCE) && !TraceContext.containsTraceContextTextHeaders(redirect, RequestHeaderAccessor.INSTANCE)) {
                TraceContext.copyTraceContextTextHeaders(original, RequestHeaderAccessor.INSTANCE, redirect, RequestHeaderAccessor.INSTANCE);
            }
        }
    }
}

