/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.httpclient.v3;

import co.elastic.apm.agent.impl.transaction.HeaderGetter;
import co.elastic.apm.agent.impl.transaction.TextHeaderGetter;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import javax.annotation.Nullable;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;

public class HttpClient3RequestHeaderAccessor
implements TextHeaderGetter<HttpMethod>,
TextHeaderSetter<HttpMethod> {
    public static HttpClient3RequestHeaderAccessor INSTANCE = new HttpClient3RequestHeaderAccessor();

    @Override
    @Nullable
    public String getFirstHeader(String headerName, HttpMethod carrier) {
        Header[] headers = carrier.getRequestHeaders(headerName);
        return headers != null && headers.length > 0 ? headers[0].getValue() : null;
    }

    @Override
    public <S> void forEach(String headerName, HttpMethod carrier, S state, HeaderGetter.HeaderConsumer<String, S> consumer) {
        Header[] headers = carrier.getRequestHeaders();
        if (headers != null) {
            for (Header header : headers) {
                consumer.accept(header.getValue(), state);
            }
        }
    }

    @Override
    public void setHeader(String headerName, String headerValue, HttpMethod carrier) {
        carrier.setRequestHeader(headerName, headerValue);
    }
}

