/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.httpclient.v3;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.httpclient.HttpClientHelper;
import co.elastic.apm.agent.httpclient.v3.HttpClient3RequestHeaderAccessor;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.util.LoggerUtils;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.commons.httpclient.CircularRedirectException;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.URI;

public class HttpClient3Instrumentation
extends TracerAwareInstrumentation {
    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("http-client", "apache-httpclient");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("org.apache.commons.httpclient.HttpMethodDirector");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("executeMethod");
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.httpclient.v3.HttpClient3Instrumentation$HttpClient3Advice";
    }

    public static class HttpClient3Advice {
        private static final Logger oneTimeNoDestinationInfoLogger = LoggerUtils.logOnce(LoggerFactory.getLogger("Apache-HttpClient-3-Destination"));

        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object onEnter(@Advice.Argument(value=0) HttpMethod httpMethod, @Advice.FieldValue(value="hostConfiguration") HostConfiguration hostConfiguration) {
            String uri;
            String protocol;
            int port;
            String host;
            AbstractSpan<?> parent = TracerAwareInstrumentation.tracer.getActive();
            if (parent == null) {
                return null;
            }
            URI httpClientURI = null;
            try {
                httpClientURI = httpMethod.getURI();
                host = hostConfiguration.getHost();
                port = hostConfiguration.getPort();
                protocol = hostConfiguration.getProtocol().getScheme();
                uri = httpClientURI.toString();
            }
            catch (Exception e) {
                try {
                    if (httpClientURI == null) {
                        oneTimeNoDestinationInfoLogger.warn("Failed to obtain Apache HttpClient destination info, null httpClientURI", e);
                        return null;
                    }
                    host = httpClientURI.getHost();
                    uri = httpClientURI.toString();
                    protocol = httpClientURI.getScheme();
                    port = httpClientURI.getPort();
                }
                catch (Exception e1) {
                    oneTimeNoDestinationInfoLogger.warn("Failed to obtain Apache HttpClient destination info", e);
                    return null;
                }
            }
            Span span = HttpClientHelper.startHttpClientSpan(parent, httpMethod.getName(), uri, protocol, host, port);
            if (span != null) {
                span.activate();
            }
            if (!TraceContext.containsTraceContextTextHeaders(httpMethod, HttpClient3RequestHeaderAccessor.INSTANCE)) {
                if (span != null) {
                    span.propagateTraceContext(httpMethod, HttpClient3RequestHeaderAccessor.INSTANCE);
                } else if (!TraceContext.containsTraceContextTextHeaders(httpMethod, HttpClient3RequestHeaderAccessor.INSTANCE)) {
                    parent.propagateTraceContext(httpMethod, HttpClient3RequestHeaderAccessor.INSTANCE);
                }
            }
            return span;
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onExit(@Advice.Thrown @Nullable Throwable thrown, @Advice.Argument(value=0) HttpMethod httpMethod, @Advice.Enter @Nullable Object enterSpan) {
            if (!(enterSpan instanceof Span)) {
                return;
            }
            Span span = (Span)enterSpan;
            StatusLine statusLine = httpMethod.getStatusLine();
            if (null != statusLine) {
                span.getContext().getHttp().withStatusCode(statusLine.getStatusCode());
            }
            if (thrown instanceof CircularRedirectException) {
                span.withOutcome(Outcome.FAILURE);
            }
            ((Span)((Span)span.captureException(thrown)).deactivate()).end();
        }
    }
}

