/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.httpclient;

import co.elastic.apm.agent.httpclient.HttpClientRequestPropertyAccessor;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.Tracer;
import co.elastic.apm.agent.impl.transaction.Span;
import java.net.http.HttpHeaders;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;

public class HttpRequestHeadersAdvice {
    private static final Tracer tracer = GlobalTracer.get();

    @Nullable
    @Advice.AssignReturned.ToReturned
    @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
    public static HttpHeaders onAfterExecute(@Advice.Return @Nullable HttpHeaders httpHeaders) {
        Span span = tracer.getActiveSpan();
        if (span == null || httpHeaders == null) {
            return httpHeaders;
        }
        LinkedHashMap<String, List<String>> headersMap = new LinkedHashMap<String, List<String>>(httpHeaders.map());
        span.propagateTraceContext(headersMap, HttpClientRequestPropertyAccessor.instance());
        return HttpHeaders.of(headersMap, (x, y) -> true);
    }
}

