/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.grpc;

import co.elastic.apm.agent.collections.WeakConcurrentProviderImpl;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.Tracer;
import co.elastic.apm.agent.impl.transaction.AbstractHeaderGetter;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TextHeaderGetter;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakConcurrent;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.Status;
import javax.annotation.Nullable;

public class GrpcHelper {
    static String GRPC = "grpc";
    private static final String FRAMEWORK_NAME = "gRPC";
    private static final GrpcHelper INSTANCE = new GrpcHelper();
    private final WeakMap<ClientCall<?, ?>, Span> clientCallSpans = WeakConcurrentProviderImpl.createWeakSpanMap();
    private final WeakMap<ClientCall<?, ?>, Span> delayedClientCallSpans = WeakConcurrentProviderImpl.createWeakSpanMap();
    private final WeakMap<ClientCall.Listener<?>, Span> clientCallListenerSpans = WeakConcurrentProviderImpl.createWeakSpanMap();
    private final WeakMap<ServerCall.Listener<?>, Transaction> serverListenerTransactions = WeakConcurrentProviderImpl.createWeakSpanMap();
    private final WeakMap<ServerCall<?, ?>, Transaction> serverCallTransactions = WeakConcurrentProviderImpl.createWeakSpanMap();
    private final WeakMap<String, Metadata.Key<String>> headerCache = WeakConcurrent.buildMap();
    private final TextHeaderSetter<Metadata> headerSetter = new GrpcHeaderSetter();
    private final TextHeaderGetter<Metadata> headerGetter = new GrpcHeaderGetter();

    public static GrpcHelper getInstance() {
        return INSTANCE;
    }

    @Nullable
    public Transaction startTransaction(Tracer tracer, ClassLoader cl, ServerCall<?, ?> serverCall, Metadata headers) {
        MethodDescriptor methodDescriptor = serverCall.getMethodDescriptor();
        if (methodDescriptor.getType() != MethodDescriptor.MethodType.UNARY) {
            return null;
        }
        if (tracer.getActive() != null) {
            return null;
        }
        Transaction transaction = tracer.startChildTransaction(headers, this.headerGetter, cl);
        if (transaction == null) {
            return null;
        }
        ((Transaction)((Transaction)transaction.withName(methodDescriptor.getFullMethodName())).withType("request")).setFrameworkName(FRAMEWORK_NAME);
        return (Transaction)transaction.activate();
    }

    public void registerTransaction(ServerCall<?, ?> serverCall, ServerCall.Listener<?> listener, Transaction transaction) {
        this.serverCallTransactions.put(serverCall, transaction);
        this.serverListenerTransactions.put(listener, transaction);
        transaction.deactivate();
    }

    public void exitServerCall(Status status, @Nullable Throwable thrown, ServerCall<?, ?> serverCall) {
        Transaction transaction = this.serverCallTransactions.remove(serverCall);
        if (transaction != null) {
            if (Outcome.UNKNOWN == transaction.getOutcome()) {
                ((Transaction)transaction.withOutcome(GrpcHelper.toServerOutcome(status))).withResultIfUnset(status.getCode().name());
            }
            transaction.captureException(thrown);
            if (thrown != null) {
                transaction.end();
            }
        }
    }

    public static Outcome toClientOutcome(@Nullable Status status) {
        if (status == null || !status.isOk()) {
            return Outcome.FAILURE;
        }
        return Outcome.SUCCESS;
    }

    public static Outcome toServerOutcome(@Nullable Status status) {
        if (status == null) {
            return Outcome.FAILURE;
        }
        switch (status.getCode()) {
            case UNKNOWN: 
            case DEADLINE_EXCEEDED: 
            case RESOURCE_EXHAUSTED: 
            case FAILED_PRECONDITION: 
            case ABORTED: 
            case INTERNAL: 
            case UNAVAILABLE: 
            case DATA_LOSS: {
                return Outcome.FAILURE;
            }
        }
        return Outcome.SUCCESS;
    }

    @Nullable
    public Transaction enterServerListenerMethod(ServerCall.Listener<?> listener) {
        Transaction transaction = this.serverListenerTransactions.get(listener);
        if (transaction != null) {
            transaction.activate();
        }
        return transaction;
    }

    public void exitServerListenerMethod(@Nullable Throwable thrown, ServerCall.Listener<?> listener, @Nullable Transaction transaction, @Nullable Status terminateStatus) {
        if (transaction == null) {
            return;
        }
        ((Transaction)transaction.captureException(thrown)).deactivate();
        if (thrown == null && terminateStatus == null) {
            return;
        }
        boolean setTerminateStatus = false;
        if (null != thrown) {
            terminateStatus = Status.fromThrowable((Throwable)thrown);
            setTerminateStatus = true;
        } else if (transaction.getOutcome() == Outcome.UNKNOWN) {
            setTerminateStatus = true;
        }
        if (setTerminateStatus) {
            transaction.withResultIfUnset(terminateStatus.getCode().name());
            transaction.withOutcome(GrpcHelper.toServerOutcome(terminateStatus));
        }
        transaction.end();
        this.serverListenerTransactions.remove(listener);
    }

    @Nullable
    public Span onClientCallCreationEntry(@Nullable AbstractSpan<?> parent, @Nullable MethodDescriptor<?, ?> method, @Nullable String authority) {
        if (null == parent) {
            return null;
        }
        if (method != null && method.getType() != MethodDescriptor.MethodType.UNARY) {
            return null;
        }
        Span span = parent.createExitSpan();
        if (span == null) {
            return null;
        }
        ((Span)((Span)span.withName(method == null ? null : method.getFullMethodName())).withType("external")).withSubtype(GRPC);
        span.getContext().getDestination().withAddressPort(authority);
        span.getContext().getServiceTarget().withType(GRPC).withName(authority).withNameOnlyDestinationResource();
        return (Span)span.activate();
    }

    public void onClientCallCreationExit(@Nullable ClientCall<?, ?> clientCall, @Nullable Span spanFromEntry) {
        if (clientCall != null) {
            Span tmp;
            Span spanToMap = spanFromEntry;
            if (spanToMap == null && (tmp = GlobalTracer.get().getActiveSpan()) != null && tmp.getSubtype() != null && tmp.getSubtype().equals(GRPC) && tmp.isExit()) {
                spanToMap = tmp;
            }
            if (spanToMap != null && !spanToMap.isDiscarded()) {
                if (this.isDelayedClientCall(clientCall)) {
                    this.delayedClientCallSpans.put(clientCall, spanToMap);
                } else {
                    this.clientCallSpans.put(clientCall, spanToMap);
                }
            }
        }
        if (spanFromEntry != null) {
            spanFromEntry.deactivate();
        }
    }

    private boolean isDelayedClientCall(ClientCall<?, ?> clientCall) {
        Class<?> clientCallClass = clientCall.getClass();
        return clientCallClass.getName().equals("io.grpc.internal.DelayedClientCall") || clientCallClass.getSuperclass().getName().equals("io.grpc.internal.DelayedClientCall");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceClientCallRegistration(ClientCall<?, ?> placeholderClientCall, ClientCall<?, ?> realClientCall) {
        Span spanOfPlaceholder = this.delayedClientCallSpans.get(placeholderClientCall);
        if (spanOfPlaceholder == null) {
            return;
        }
        try {
            Span spanOfRealClientCall = this.clientCallSpans.get(realClientCall);
            boolean mapPlaceholderSpanToRealClientCall = false;
            if (spanOfRealClientCall == null) {
                mapPlaceholderSpanToRealClientCall = true;
            } else if (spanOfRealClientCall != spanOfPlaceholder) {
                if (!spanOfRealClientCall.isFinished()) {
                    ((Span)spanOfRealClientCall.requestDiscarding()).end();
                }
                mapPlaceholderSpanToRealClientCall = true;
            } else if (spanOfRealClientCall.isFinished()) {
                this.clientCallSpans.remove(realClientCall);
            }
            if (mapPlaceholderSpanToRealClientCall && !spanOfPlaceholder.isFinished()) {
                this.clientCallSpans.put(realClientCall, spanOfPlaceholder);
            }
        }
        finally {
            this.delayedClientCallSpans.remove(placeholderClientCall);
        }
    }

    @Nullable
    public Span clientCallStartEnter(ClientCall<?, ?> clientCall, ClientCall.Listener<?> listener, Metadata headers) {
        Span span = this.clientCallSpans.remove(clientCall);
        if (span == null) {
            return null;
        }
        this.clientCallListenerSpans.put(listener, span);
        if (!TraceContext.containsTraceContextTextHeaders(headers, this.headerGetter)) {
            span.propagateTraceContext(headers, this.headerSetter);
        }
        return (Span)span.activate();
    }

    public void clientCallStartExit(@Nullable Span spanFromEntry, ClientCall.Listener<?> listener, @Nullable Throwable thrown) {
        if (spanFromEntry != null) {
            spanFromEntry.deactivate();
        }
        if (thrown != null) {
            this.clientCallListenerSpans.remove(listener);
            if (spanFromEntry != null) {
                ((Span)spanFromEntry.withOutcome(Outcome.FAILURE)).end();
            }
        }
    }

    public void cancelCall(ClientCall<?, ?> clientCall, @Nullable Throwable cause) {
        WeakMap<ClientCall<?, ?>, Span> clientCallMap = this.isDelayedClientCall(clientCall) ? this.delayedClientCallSpans : this.clientCallSpans;
        Span span = clientCallMap.get(clientCall);
        if (span != null) {
            if (!span.isFinished()) {
                ((Span)((Span)span.captureException(cause)).withOutcome(GrpcHelper.toClientOutcome(Status.CANCELLED))).end();
            }
            clientCallMap.remove(clientCall);
        }
    }

    @Nullable
    public Span enterClientListenerMethod(ClientCall.Listener<?> listener) {
        Span span = this.clientCallListenerSpans.get(listener);
        if (span != null) {
            if (span.isFinished()) {
                this.clientCallListenerSpans.remove(listener);
                span = null;
            } else if (span == GlobalTracer.get().getActiveSpan()) {
                span = null;
            } else {
                span.activate();
            }
        }
        return span;
    }

    public void exitClientListenerMethod(@Nullable Throwable thrown, ClientCall.Listener<?> listener, @Nullable Span span, @Nullable Status onCloseStatus) {
        boolean lastCall;
        boolean bl = lastCall = onCloseStatus != null || thrown != null;
        if (span != null) {
            ((Span)span.captureException(thrown)).deactivate();
            if (lastCall) {
                ((Span)span.withOutcome(GrpcHelper.toClientOutcome(onCloseStatus))).end();
            }
        }
        if (lastCall) {
            this.clientCallListenerSpans.remove(listener);
        }
    }

    private Metadata.Key<String> getHeader(String headerName) {
        Metadata.Key key = this.headerCache.get(headerName);
        if (key == null) {
            key = Metadata.Key.of((String)headerName, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
            this.headerCache.put(headerName, (Metadata.Key<String>)key);
        }
        return key;
    }

    private class GrpcHeaderGetter
    extends AbstractHeaderGetter<String, Metadata>
    implements TextHeaderGetter<Metadata> {
        private GrpcHeaderGetter() {
        }

        @Override
        @Nullable
        public String getFirstHeader(String headerName, Metadata carrier) {
            return (String)carrier.get(GrpcHelper.this.getHeader(headerName));
        }
    }

    private class GrpcHeaderSetter
    implements TextHeaderSetter<Metadata> {
        private GrpcHeaderSetter() {
        }

        @Override
        public void setHeader(String headerName, String headerValue, Metadata carrier) {
            carrier.put(GrpcHelper.this.getHeader(headerName), (Object)headerValue);
        }
    }
}

