/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.finaglehttpclient.helper;

import co.elastic.apm.agent.impl.transaction.HeaderGetter;
import co.elastic.apm.agent.impl.transaction.TextHeaderGetter;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import com.twitter.finagle.http.Request;
import javax.annotation.Nullable;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;

public class RequestHeaderAccessor
implements TextHeaderGetter<Request>,
TextHeaderSetter<Request> {
    public static final RequestHeaderAccessor INSTANCE = new RequestHeaderAccessor();

    @Override
    public void setHeader(String headerName, String headerValue, Request request) {
        request.headerMap().set(headerName, headerValue);
    }

    @Override
    @Nullable
    public String getFirstHeader(String headerName, Request request) {
        Option headerValue = request.headerMap().get(headerName);
        if (headerValue.nonEmpty()) {
            return (String)headerValue.get();
        }
        return null;
    }

    @Override
    public <S> void forEach(String headerName, Request carrier, S state, HeaderGetter.HeaderConsumer<String, S> consumer) {
        Seq headers = carrier.headerMap().getAll(headerName);
        Iterator headerIterator = headers.iterator();
        while (headerIterator.hasNext()) {
            consumer.accept((String)headerIterator.next(), state);
        }
    }
}

