/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.finaglehttpclient;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakConcurrent;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakSet;
import com.twitter.finagle.http.Request;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class FinagleTlsFilterInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("com.twitter.finagle.http.TlsFilter");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("apply").and(ElementMatchers.returns(ElementMatchers.named("com.twitter.util.Future"))).and(ElementMatchers.takesArguments(2)).and(ElementMatchers.takesArgument(0, ElementMatchers.named("com.twitter.finagle.http.Request"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("com.twitter.finagle.Service")));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("http-client", "finagle-httpclient");
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.finaglehttpclient.FinagleTlsFilterInstrumentation$TlsFilterAdvice";
    }

    public static class TlsFilterAdvice {
        private static final WeakSet<Request> TLS_REQUESTS = WeakConcurrent.buildSet();

        public static boolean isTlsRequest(Request request) {
            return TLS_REQUESTS.contains(request);
        }

        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static void onBeforeExecute(@Nullable @Advice.Argument(value=0) Request request) {
            if (request == null) {
                return;
            }
            TLS_REQUESTS.add(request);
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onExit(@Nullable @Advice.Argument(value=0) Request request) {
            if (request == null) {
                return;
            }
            TLS_REQUESTS.remove(request);
        }
    }
}

