/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.finaglehttpclient;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.finaglehttpclient.FinagleTlsFilterInstrumentation;
import co.elastic.apm.agent.finaglehttpclient.helper.RequestHeaderAccessor;
import co.elastic.apm.agent.httpclient.HttpClientHelper;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakConcurrent;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.tracing.Trace;
import com.twitter.util.Future;
import com.twitter.util.FutureEventListener;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class FinaglePayloadSizeFilterInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("com.twitter.finagle.http.filter.PayloadSizeFilter");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("apply").and(ElementMatchers.returns(ElementMatchers.named("com.twitter.util.Future"))).and(ElementMatchers.takesArguments(2)).and(ElementMatchers.takesArgument(0, ElementMatchers.named("com.twitter.finagle.http.Request"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("com.twitter.finagle.Service")));
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return CustomElementMatchers.classLoaderCanLoadClass("com.twitter.finagle.http.Request$Inbound");
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("http-client", "finagle-httpclient");
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.finaglehttpclient.FinaglePayloadSizeFilterInstrumentation$PayloadSizeFilterAdvice";
    }

    public static class PayloadSizeFilterAdvice {
        private static final WeakMap<Request, Span> inflightSpansWithUnknownHost = WeakConcurrent.buildMap();
        private static final Class<?> INBOUND_REQUEST_CLASS;
        private static final Logger logger;

        @Nullable
        public static Span getAndRemoveSpanWithUnknownHostForRequest(Request forRequest) {
            return inflightSpansWithUnknownHost.remove(forRequest);
        }

        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object onBeforeExecute(@Nullable @Advice.Argument(value=0) Request request) {
            if (request == null || INBOUND_REQUEST_CLASS.isInstance(request)) {
                return null;
            }
            AbstractSpan<?> parent = TracerAwareInstrumentation.tracer.getActive();
            if (parent == null) {
                return null;
            }
            Trace.apply().recordClientSend();
            boolean hostUnknown = true;
            String host = "unknown-host";
            if (request.host().nonEmpty()) {
                host = (String)request.host().get();
                hostUnknown = false;
            }
            URI uri = PayloadSizeFilterAdvice.resolveURI(request, host);
            Span span = HttpClientHelper.startHttpClientSpan(parent, request.method().name(), uri, null);
            if (span != null) {
                span.activate();
                if (hostUnknown) {
                    inflightSpansWithUnknownHost.put(request, span);
                }
            }
            if (!TraceContext.containsTraceContextTextHeaders(request, RequestHeaderAccessor.INSTANCE)) {
                if (span != null) {
                    span.propagateTraceContext(request, RequestHeaderAccessor.INSTANCE);
                } else if (!TraceContext.containsTraceContextTextHeaders(request, RequestHeaderAccessor.INSTANCE)) {
                    parent.propagateTraceContext(request, RequestHeaderAccessor.INSTANCE);
                }
            }
            return span;
        }

        @Nonnull
        private static URI resolveURI(@Nonnull Request request, String host) {
            StringBuilder uriStr = new StringBuilder();
            if (FinagleTlsFilterInstrumentation.TlsFilterAdvice.isTlsRequest(request)) {
                uriStr.append("https://");
            } else {
                uriStr.append("http://");
            }
            uriStr.append(host).append(request.uri());
            return URI.create(uriStr.toString());
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onExit(final @Nullable @Advice.Argument(value=0) Request request, @Advice.Enter @Nullable Object spanObj, @Advice.Thrown @Nullable Throwable thrown, @Advice.Return @Nullable Future<Response> response) {
            if (spanObj == null) {
                return;
            }
            final Span span = (Span)spanObj;
            span.deactivate();
            if (thrown != null) {
                span.captureException(thrown);
                PayloadSizeFilterAdvice.endSpanForRequest(request, span);
            } else if (response == null) {
                logger.error("Expected response-future to be not null", new Throwable());
                PayloadSizeFilterAdvice.endSpanForRequest(request, span);
            } else {
                response.addEventListener((FutureEventListener)new FutureEventListener<Response>(){

                    public void onSuccess(Response responseVal) {
                        span.getContext().getHttp().withStatusCode(responseVal.statusCode());
                        PayloadSizeFilterAdvice.endSpanForRequest(request, span);
                    }

                    public void onFailure(Throwable cause) {
                        span.captureException(cause);
                        PayloadSizeFilterAdvice.endSpanForRequest(request, span);
                    }
                });
            }
        }

        private static void endSpanForRequest(@Nullable Request request, Span span) {
            if (request != null) {
                inflightSpansWithUnknownHost.remove(request);
            }
            span.end();
        }

        static {
            try {
                INBOUND_REQUEST_CLASS = Class.forName("com.twitter.finagle.http.Request$Inbound");
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            logger = LoggerFactory.getLogger(PayloadSizeFilterAdvice.class);
        }
    }
}

