/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.finaglehttpclient;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.finaglehttpclient.FinaglePayloadSizeFilterInstrumentation;
import co.elastic.apm.agent.httpclient.HttpClientHelper;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import com.twitter.finagle.http.Request;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class FinagleExceptionSourceFilterInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("com.twitter.finagle.filter.ExceptionSourceFilter");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("apply").and(ElementMatchers.returns(ElementMatchers.named("com.twitter.util.Future"))).and(ElementMatchers.takesArguments(2)).and(ElementMatchers.takesArgument(0, Object.class)).and(ElementMatchers.takesArgument(1, ElementMatchers.named("com.twitter.finagle.Service")));
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return CustomElementMatchers.classLoaderCanLoadClass("com.twitter.finagle.http.Request$Inbound");
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("http-client", "finagle-httpclient");
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.finaglehttpclient.FinagleExceptionSourceFilterInstrumentation$ExceptionSourceFilterAdvice";
    }

    public static class ExceptionSourceFilterAdvice {
        private static final String SERVICE_NAME_FIELD = "com$twitter$finagle$filter$ExceptionSourceFilter$$serviceName";
        private static final Logger logger = LoggerFactory.getLogger(ExceptionSourceFilterAdvice.class);

        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static void onBeforeExecute(@Nullable @Advice.Argument(value=0) Object serviceArg, @Nullable @Advice.FieldValue(value="com$twitter$finagle$filter$ExceptionSourceFilter$$serviceName") String serviceName) {
            Span spanToEnhance;
            if (serviceArg instanceof Request && (spanToEnhance = FinaglePayloadSizeFilterInstrumentation.PayloadSizeFilterAdvice.getAndRemoveSpanWithUnknownHostForRequest((Request)serviceArg)) != null && serviceName != null && !serviceName.isEmpty()) {
                ExceptionSourceFilterAdvice.updateSpanHostname(spanToEnhance, serviceName);
            }
        }

        private static void updateSpanHostname(Span spanToEnhance, String serviceName) {
            CharSequence currentUriStr = spanToEnhance.getContext().getHttp().getUrl();
            String method = spanToEnhance.getContext().getHttp().getMethod();
            if (currentUriStr.length() == 0 || method == null || method.isEmpty()) {
                return;
            }
            try {
                URI parsed = URI.create(currentUriStr.toString());
                URI updated = new URI(parsed.getScheme().toLowerCase(Locale.US), serviceName, parsed.getPath(), parsed.getQuery(), parsed.getFragment());
                HttpClientHelper.updateHttpSpanNameAndContext(spanToEnhance, method, updated.toString(), updated.getScheme(), updated.getHost(), updated.getPort());
            }
            catch (Exception e) {
                logger.error("Failed to update hostname on finagle http client span", e);
            }
        }
    }
}

