/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.ecs_logging;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.configuration.ServiceInfo;
import co.elastic.apm.agent.ecs_logging.AbstractLog4j2ServiceInstrumentation;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.logging.log4j2.EcsLayout;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class Log4j2ServiceVersionInstrumentation
extends AbstractLog4j2ServiceInstrumentation {
    @Override
    public ElementMatcher.Junction<? super TypeDescription> getTypeMatcher() {
        return super.getTypeMatcher().and(ElementMatchers.declaresMethod(ElementMatchers.named("setServiceVersion")));
    }

    public static class AdviceClass {
        private static final ElasticApmTracer tracer = GlobalTracer.requireTracerImpl();

        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static void onEnter(@Advice.This EcsLayout.Builder builder) {
            if (builder.getServiceVersion() == null || builder.getServiceVersion().isEmpty()) {
                ServiceInfo serviceInfo = tracer.getServiceInfoForClassLoader(Thread.currentThread().getContextClassLoader());
                String configuredServiceVersion = tracer.getConfig(CoreConfiguration.class).getServiceVersion();
                builder.setServiceVersion(serviceInfo != null ? serviceInfo.getServiceVersion() : configuredServiceVersion);
            }
        }
    }
}

