/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.ecs_logging;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.configuration.ServiceInfo;
import co.elastic.apm.agent.ecs_logging.AbstractLog4j2ServiceInstrumentation;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.logging.log4j2.EcsLayout;
import net.bytebuddy.asm.Advice;

public class Log4j2ServiceNameInstrumentation
extends AbstractLog4j2ServiceInstrumentation {

    public static class AdviceClass {
        private static final ElasticApmTracer tracer = GlobalTracer.requireTracerImpl();

        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static void onEnter(@Advice.This EcsLayout.Builder builder) {
            if (builder.getServiceName() == null || builder.getServiceName().isEmpty()) {
                ServiceInfo serviceInfo = tracer.getServiceInfoForClassLoader(Thread.currentThread().getContextClassLoader());
                String configuredServiceName = tracer.getConfig(CoreConfiguration.class).getServiceName();
                builder.setServiceName(serviceInfo != null ? serviceInfo.getServiceName() : configuredServiceName);
            }
        }
    }
}

