/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.dubbo.advice;

import co.elastic.apm.agent.dubbo.helper.AlibabaDubboTextMapPropagator;
import co.elastic.apm.agent.dubbo.helper.DubboTraceHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.util.PrivilegedActionUtils;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.protocol.dubbo.FutureAdapter;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;

public class AlibabaMonitorFilterAdvice {
    private static final ElasticApmTracer tracer = GlobalTracer.requireTracerImpl();

    @Nullable
    @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
    public static Object onEnterFilterInvoke(@Advice.Argument(value=1) Invocation invocation) {
        Transaction transaction;
        RpcContext context = RpcContext.getContext();
        AbstractSpan<?> active = tracer.getActive();
        if (context.isConsumerSide() && active != null) {
            Span span = DubboTraceHelper.createConsumerSpan(tracer, invocation.getInvoker().getInterface(), invocation.getMethodName(), context.getRemoteAddress());
            if (span != null) {
                span.propagateTraceContext(context, AlibabaDubboTextMapPropagator.INSTANCE);
                return span;
            }
        } else if (context.isProviderSide() && active == null && (transaction = tracer.startChildTransaction(context, AlibabaDubboTextMapPropagator.INSTANCE, PrivilegedActionUtils.getClassLoader(Invocation.class))) != null) {
            transaction.activate();
            DubboTraceHelper.fillTransaction(transaction, invocation.getInvoker().getInterface(), invocation.getMethodName());
            return transaction;
        }
        return null;
    }

    @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
    public static void onExitFilterInvoke(@Advice.Argument(value=1) Invocation invocation, @Advice.Return @Nullable Result result, @Advice.Enter @Nullable Object spanObj, @Advice.Thrown @Nullable Throwable t) {
        AbstractSpan span = (AbstractSpan)spanObj;
        if (span == null) {
            return;
        }
        Throwable resultException = null;
        if (result != null) {
            resultException = result.getException();
        }
        ((AbstractSpan)((AbstractSpan)((AbstractSpan)span.captureException(t)).captureException(resultException)).withOutcome(t != null || resultException != null ? Outcome.FAILURE : Outcome.SUCCESS)).deactivate();
        if (!(RpcContext.getContext().getFuture() instanceof FutureAdapter)) {
            span.end();
        }
    }
}

