/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.dubbo;

import co.elastic.apm.agent.dubbo.AbstractAlibabaDubboInstrumentation;
import co.elastic.apm.agent.dubbo.AlibabaResponseFutureInstrumentation;
import co.elastic.apm.agent.sdk.DynamicTransformer;
import co.elastic.apm.agent.sdk.ElasticApmInstrumentation;
import com.alibaba.dubbo.rpc.protocol.dubbo.FutureAdapter;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class AlibabaRpcContextInstrumentation
extends AbstractAlibabaDubboInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("com.alibaba.dubbo.rpc.RpcContext");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("setFuture").and(ElementMatchers.takesArgument(0, ElementMatchers.named("java.util.concurrent.Future")));
    }

    public static class AdviceClass {
        private static final List<Class<? extends ElasticApmInstrumentation>> RESPONSE_FUTURE_INSTRUMENTATION = Collections.singletonList(AlibabaResponseFutureInstrumentation.class);

        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static void onEnter(@Advice.Argument(value=0) Future<?> future) {
            if (future instanceof FutureAdapter) {
                DynamicTransformer.ensureInstrumented(((FutureAdapter)future).getFuture().getClass(), RESPONSE_FUTURE_INSTRUMENTATION);
            }
        }
    }
}

