/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.db.signature;

import co.elastic.apm.agent.db.signature.ScannerFilter;

public class Scanner {
    private String input = "";
    private int start;
    private int end;
    private int pos;
    private int inputLength;
    private final ScannerFilter filter;

    public Scanner() {
        this(ScannerFilter.NoOp.INSTANCE);
    }

    public Scanner(ScannerFilter filter) {
        this.filter = filter;
    }

    public void setQuery(String sql) {
        this.input = sql;
        this.filter.reset();
        this.inputLength = sql.length();
        this.start = 0;
        this.end = 0;
        this.pos = 0;
    }

    public Token scanWhile(Token token) {
        Token t = this.scan();
        while (t != Token.EOF) {
            if (t != token) {
                return t;
            }
            t = this.scan();
        }
        return Token.EOF;
    }

    public boolean scanUntil(Token token) {
        Token t = this.scan();
        while (t != Token.EOF) {
            if (t == token) {
                return true;
            }
            t = this.scan();
        }
        return false;
    }

    public boolean scanToken(Token token) {
        Token t = this.scan();
        while (t != Token.EOF) {
            if (t == token) {
                return true;
            }
            if (t != Token.COMMENT) {
                return false;
            }
            t = this.scan();
        }
        return false;
    }

    public Token scan() {
        if (!this.hasNext()) {
            return Token.EOF;
        }
        char c = this.next();
        while (Character.isSpaceChar(c) || this.filter.skip(this, c)) {
            if (this.hasNext()) {
                c = this.next();
                continue;
            }
            return Token.EOF;
        }
        this.start = this.pos - 1;
        if (c == '_' || Character.isLetter(c)) {
            return this.scanKeywordOrIdentifier(c != '_');
        }
        if (Character.isDigit(c)) {
            return this.scanNumericLiteral();
        }
        switch (c) {
            case '\'': {
                return this.scanStringLiteral();
            }
            case '\"': {
                return this.scanQuotedIdentifier('\"');
            }
            case '[': {
                return this.scanQuotedIdentifier(']');
            }
            case '`': {
                return this.scanQuotedIdentifier('`');
            }
            case '(': {
                return Token.LPAREN;
            }
            case ')': {
                return Token.RPAREN;
            }
            case '-': {
                if (this.isNextChar('-')) {
                    this.next();
                    return this.scanSimpleComment();
                }
                return Token.OTHER;
            }
            case '/': {
                if (this.isNextChar('*')) {
                    this.next();
                    return this.scanBracketedComment();
                }
                if (this.isNextChar('/')) {
                    this.next();
                    return this.scanSimpleComment();
                }
                return Token.OTHER;
            }
            case '.': {
                return Token.PERIOD;
            }
            case '$': {
                if (!this.hasNext()) {
                    return Token.OTHER;
                }
                char next = this.peek();
                if (Character.isDigit(next)) {
                    while (this.hasNext() && Character.isDigit(this.peek())) {
                        this.next();
                    }
                    return Token.OTHER;
                }
                if (next != '$' && next != '_' && !Character.isLetter(next)) break;
                while (this.hasNext()) {
                    c = this.next();
                    if (c == '$') {
                        String text = this.text();
                        int i = this.input.indexOf(text, this.pos);
                        if (i >= 0) {
                            this.end = i + text.length();
                            this.pos = i + text.length();
                            return Token.STRING;
                        }
                        return Token.OTHER;
                    }
                    if (Character.isLetter(c) || Character.isDigit(c) || c == '_' || !Character.isSpaceChar(c)) continue;
                    --this.end;
                    return Token.OTHER;
                }
                return Token.OTHER;
            }
        }
        return Token.OTHER;
    }

    private Token scanKeywordOrIdentifier(boolean maybeKeyword) {
        while (this.hasNext()) {
            char c = this.peek();
            if (Character.isDigit(c) || c == '_' || c == '$') {
                maybeKeyword = false;
            } else if (!Character.isLetter(c)) break;
            this.next();
        }
        if (!maybeKeyword) {
            return Token.IDENT;
        }
        for (Token token : Token.getKeywordsByLength(this.textLength())) {
            if (!this.isTextEqualIgnoreCase(token.name())) continue;
            return token;
        }
        return Token.IDENT;
    }

    private Token scanNumericLiteral() {
        boolean hasPeriod = false;
        boolean hasExponent = false;
        block4: while (this.hasNext()) {
            char c = this.peek();
            if (Character.isDigit(c)) {
                this.next();
                continue;
            }
            switch (c) {
                case '.': {
                    if (hasPeriod) {
                        return Token.NUMBER;
                    }
                    this.next();
                    hasPeriod = true;
                    continue block4;
                }
                case 'E': 
                case 'e': {
                    if (hasExponent) {
                        return Token.NUMBER;
                    }
                    this.next();
                    hasExponent = true;
                    if (!this.isNextChar('+') && !this.isNextChar('-')) continue block4;
                    this.next();
                    continue block4;
                }
            }
            return Token.NUMBER;
        }
        return Token.NUMBER;
    }

    private Token scanStringLiteral() {
        while (this.hasNext()) {
            char c = this.next();
            if (c == '\\' && this.hasNext()) {
                this.next();
                continue;
            }
            if (c != '\'') continue;
            if (this.isNextChar('\'')) {
                this.next();
                continue;
            }
            return Token.STRING;
        }
        return Token.EOF;
    }

    private Token scanQuotedIdentifier(char delimiter) {
        while (this.hasNext()) {
            char c = this.next();
            if (c != delimiter) continue;
            if (delimiter == '\"' && this.isNextChar('\"')) {
                this.next();
                continue;
            }
            ++this.start;
            --this.end;
            return Token.IDENT;
        }
        return Token.EOF;
    }

    private Token scanSimpleComment() {
        while (this.hasNext()) {
            if (this.next() != '\n') continue;
            return Token.COMMENT;
        }
        return Token.COMMENT;
    }

    private Token scanBracketedComment() {
        int nesting = 1;
        while (this.hasNext()) {
            char c = this.next();
            switch (c) {
                case '/': {
                    if (this.isNextChar('*')) {
                        this.next();
                        ++nesting;
                    }
                }
                case '*': {
                    if (!this.isNextChar('/')) break;
                    this.next();
                    if (--nesting != 0) break;
                    return Token.COMMENT;
                }
            }
        }
        return Token.EOF;
    }

    private char peek() {
        return this.input.charAt(this.pos);
    }

    public char next() {
        char c = this.peek();
        ++this.pos;
        this.end = this.pos;
        return c;
    }

    private boolean hasNext() {
        return this.pos < this.inputLength;
    }

    private boolean isTextEqualIgnoreCase(String name) {
        return this.input.regionMatches(true, this.start, name, 0, this.textLength());
    }

    String text() {
        StringBuilder sb = new StringBuilder();
        this.appendCurrentTokenText(sb);
        return sb.toString();
    }

    public void appendCurrentTokenText(StringBuilder sb) {
        sb.append(this.input, this.start, this.end);
    }

    public int textLength() {
        return this.end - this.start;
    }

    private boolean isNextChar(char c) {
        return this.hasNext() && this.peek() == c;
    }

    public boolean isNextCharIgnoreCase(char c) {
        return this.hasNext() && Character.toLowerCase(this.peek()) == Character.toLowerCase(c);
    }

    public static enum Token {
        OTHER,
        EOF,
        COMMENT,
        IDENT,
        NUMBER,
        STRING,
        PERIOD,
        LPAREN,
        RPAREN,
        AS,
        CALL,
        DELETE,
        FROM,
        INSERT,
        INTO,
        OR,
        REPLACE,
        SELECT,
        SET,
        TABLE,
        TRUNCATE,
        UPDATE,
        MERGE,
        USING;

        private static final Token[] EMPTY;
        private static final Token[][] KEYWORDS_BY_LENGTH;

        public static Token[] getKeywordsByLength(int length) {
            if (length < KEYWORDS_BY_LENGTH.length) {
                return KEYWORDS_BY_LENGTH[length];
            }
            return EMPTY;
        }

        static {
            EMPTY = new Token[0];
            KEYWORDS_BY_LENGTH = new Token[][]{new Token[0], new Token[0], {AS, OR}, {SET}, {CALL, FROM, INTO}, {TABLE, MERGE, USING}, {DELETE, INSERT, SELECT, UPDATE}, {REPLACE}, {TRUNCATE}};
        }
    }
}

