/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.configuration.converter;

import co.elastic.apm.agent.configuration.converter.TimeDuration;
import org.stagemonitor.configuration.ConfigurationOption;
import org.stagemonitor.configuration.converter.AbstractValueConverter;

public class TimeDurationValueConverter
extends AbstractValueConverter<TimeDuration> {
    private final String defaultDurationSuffix;
    private final boolean canUseMicros;

    private TimeDurationValueConverter(String defaultDurationSuffix, boolean canUseMicros) {
        this.defaultDurationSuffix = defaultDurationSuffix;
        this.canUseMicros = canUseMicros;
    }

    public static TimeDurationValueConverter withDefaultDuration() {
        return new TimeDurationValueConverter("", false);
    }

    @Deprecated
    public static TimeDurationValueConverter withDefaultDuration(String defaultDurationSuffix) {
        return new TimeDurationValueConverter(defaultDurationSuffix, false);
    }

    public static TimeDurationValueConverter withDefaultFineDuration() {
        return new TimeDurationValueConverter("", true);
    }

    public static ConfigurationOption.ConfigurationOptionBuilder<TimeDuration> durationOption(String defaultDuration) {
        return ConfigurationOption.builder(new TimeDurationValueConverter(defaultDuration, false), TimeDuration.class);
    }

    public static ConfigurationOption.ConfigurationOptionBuilder<TimeDuration> fineDurationOption() {
        return ConfigurationOption.builder(new TimeDurationValueConverter("", true), TimeDuration.class);
    }

    @Override
    public TimeDuration convert(String s) throws IllegalArgumentException {
        if (!(s.endsWith("us") || s.endsWith("ms") || s.endsWith("s") || s.endsWith("m"))) {
            s = s + this.defaultDurationSuffix;
        }
        return this.canUseMicros ? TimeDuration.ofFine(s) : TimeDuration.of(s);
    }

    @Override
    public String toString(TimeDuration value) {
        return value.toString();
    }

    public boolean isCanUseMicros() {
        return this.canUseMicros;
    }
}

