/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.configuration.converter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeDuration
implements Comparable<TimeDuration> {
    public static final Pattern DURATION_PATTERN = Pattern.compile("^(-)?(\\d+)(us|ms|s|m)$");
    private final String durationString;
    private final long durationMicros;

    private TimeDuration(String durationString, long durationMicros) {
        this.durationString = durationString;
        this.durationMicros = durationMicros;
    }

    public static TimeDuration of(String durationString) {
        return TimeDuration.with(durationString, false);
    }

    public static TimeDuration ofFine(String durationString) {
        return TimeDuration.with(durationString, true);
    }

    private static TimeDuration with(String durationString, boolean allowMicros) {
        Matcher matcher = DURATION_PATTERN.matcher(durationString);
        if (matcher.matches()) {
            long duration = Long.parseLong(matcher.group(2));
            if (matcher.group(1) != null) {
                duration *= -1L;
            }
            String unit = matcher.group(3);
            if (!allowMicros && "us".equals(unit)) {
                throw new IllegalArgumentException("Invalid duration '" + durationString + "', 'us' are only supported for fine granular durations");
            }
            return new TimeDuration(durationString, duration * (long)TimeDuration.getDurationMultiplier(unit));
        }
        throw new IllegalArgumentException("Invalid duration '" + durationString + "'");
    }

    private static int getDurationMultiplier(String unit) {
        switch (unit) {
            case "us": {
                return 1;
            }
            case "ms": {
                return 1000;
            }
            case "s": {
                return 1000000;
            }
            case "m": {
                return 60000000;
            }
        }
        throw new IllegalStateException("Duration unit '" + unit + "' is unknown");
    }

    public long getMillis() {
        return this.durationMicros / 1000L;
    }

    public long getMicros() {
        return this.durationMicros;
    }

    public String toString() {
        return this.durationString;
    }

    @Override
    public int compareTo(TimeDuration o) {
        return Long.compare(this.durationMicros, o.durationMicros);
    }
}

