/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.configuration.converter;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.stagemonitor.configuration.converter.AbstractValueConverter;
import org.stagemonitor.configuration.converter.DoubleValueConverter;

public class RoundedDoubleConverter
extends AbstractValueConverter<Double> {
    public static final int DEFAULT_PRECISION = 4;
    private static final RoundedDoubleConverter DEFAULT_INSTANCE = new RoundedDoubleConverter(4);
    private final double precisionFactor;
    private final NumberFormat numberFormat;

    public static RoundedDoubleConverter withDefaultPrecision() {
        return DEFAULT_INSTANCE;
    }

    RoundedDoubleConverter(int precisionDigits) {
        if (precisionDigits < 0) {
            throw new IllegalArgumentException("expects a zero-or-positive precision");
        }
        StringBuilder format = new StringBuilder("#.");
        for (int i = 0; i < precisionDigits; ++i) {
            format.append("#");
        }
        this.numberFormat = new DecimalFormat(format.toString(), DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        this.precisionFactor = Math.pow(10.0, precisionDigits);
    }

    @Override
    public Double convert(String s) throws IllegalArgumentException {
        return this.round(DoubleValueConverter.INSTANCE.convert(s));
    }

    @Override
    public String toString(Double value) {
        return this.numberFormat.format(value);
    }

    public double round(double value) {
        double rounded = (double)Math.round(value * this.precisionFactor) / this.precisionFactor;
        if (value > 0.0 && rounded == 0.0) {
            rounded = 1.0 / this.precisionFactor;
        }
        return rounded;
    }
}

