/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.configuration.converter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.stagemonitor.configuration.converter.AbstractCollectionValueConverter;
import org.stagemonitor.configuration.converter.ValueConverter;

public class ListValueConverter<T>
extends AbstractCollectionValueConverter<List<T>, T> {
    public static final String COMMA_OUT_OF_BRACKETS = ",(?![^()]*\\))";
    protected final String delimiter;

    public ListValueConverter(ValueConverter<T> valueConverter) {
        super(valueConverter);
        this.delimiter = ",";
    }

    public ListValueConverter(ValueConverter<T> valueConverter, String delimiter) {
        super(valueConverter);
        this.delimiter = delimiter;
    }

    @Override
    public List<T> convert(String s) {
        if (s != null && s.length() > 0) {
            ArrayList result = new ArrayList();
            for (String split : s.split(this.delimiter)) {
                result.add(this.valueConverter.convert(split.trim()));
            }
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }
}

