/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.concurrent;

import co.elastic.apm.agent.collections.WeakConcurrentProviderImpl;
import co.elastic.apm.agent.concurrent.RunnableCallableForkJoinTaskInstrumentation;
import co.elastic.apm.agent.impl.Tracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.ElasticContext;
import co.elastic.apm.agent.sdk.DynamicTransformer;
import co.elastic.apm.agent.sdk.ElasticApmInstrumentation;
import co.elastic.apm.agent.sdk.state.GlobalState;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinTask;
import javax.annotation.Nullable;

@GlobalState
public class JavaConcurrent {
    private static final WeakMap<Object, AbstractSpan<?>> contextMap = WeakConcurrentProviderImpl.createWeakSpanMap();
    private static final List<Class<? extends ElasticApmInstrumentation>> RUNNABLE_CALLABLE_FJTASK_INSTRUMENTATION = Collections.singletonList(RunnableCallableForkJoinTaskInstrumentation.class);
    static final ThreadLocal<Boolean> needsContext = new ThreadLocal();
    private static final Set<String> EXCLUDED_EXECUTABLE_TYPES = new HashSet<String>();

    private static void removeContext(Object o) {
        contextMap.remove(o);
    }

    private static boolean shouldAvoidContextPropagation(@Nullable Object executable) {
        return executable == null || Thread.currentThread().getName().startsWith("elastic-apm-") || EXCLUDED_EXECUTABLE_TYPES.contains(executable.getClass().getName()) || needsContext.get() == Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static AbstractSpan<?> restoreContext(Object o, Tracer tracer) {
        needsContext.set(Boolean.TRUE);
        AbstractSpan<?> context = contextMap.get(o);
        if (context == null) {
            return null;
        }
        try {
            if (tracer.getActive() != context) {
                ElasticContext elasticContext = context.activate();
                return elasticContext;
            }
            AbstractSpan<?> abstractSpan = null;
            return abstractSpan;
        }
        finally {
            contextMap.remove(o);
        }
    }

    @Nullable
    public static Runnable withContext(@Nullable Runnable runnable, Tracer tracer) {
        if (JavaConcurrent.shouldAvoidContextPropagation(runnable)) {
            return runnable;
        }
        needsContext.set(Boolean.FALSE);
        AbstractSpan<?> active = tracer.getActive();
        if (active == null) {
            return runnable;
        }
        if (JavaConcurrent.isLambda(runnable)) {
            runnable = new RunnableLambdaWrapper(runnable);
        }
        JavaConcurrent.captureContext(runnable, active);
        return runnable;
    }

    private static void captureContext(Object task, AbstractSpan<?> active) {
        DynamicTransformer.ensureInstrumented(task.getClass(), RUNNABLE_CALLABLE_FJTASK_INSTRUMENTATION);
        contextMap.put(task, active);
        active.setNonDiscardable();
    }

    @Nullable
    public static <T> Callable<T> withContext(@Nullable Callable<T> callable, Tracer tracer) {
        if (JavaConcurrent.shouldAvoidContextPropagation(callable)) {
            return callable;
        }
        needsContext.set(Boolean.FALSE);
        AbstractSpan<?> active = tracer.getActive();
        if (active == null) {
            return callable;
        }
        if (JavaConcurrent.isLambda(callable)) {
            callable = new CallableLambdaWrapper<T>(callable);
        }
        JavaConcurrent.captureContext(callable, active);
        return callable;
    }

    @Nullable
    public static <T> ForkJoinTask<T> withContext(@Nullable ForkJoinTask<T> task, Tracer tracer) {
        if (JavaConcurrent.shouldAvoidContextPropagation(task)) {
            return task;
        }
        needsContext.set(Boolean.FALSE);
        AbstractSpan<?> active = tracer.getActive();
        if (active == null) {
            return task;
        }
        JavaConcurrent.captureContext(task, active);
        return task;
    }

    public static void doFinally(@Nullable Throwable thrown, @Nullable Object contextObject) {
        needsContext.set(Boolean.TRUE);
        if (thrown != null && contextObject != null) {
            JavaConcurrent.removeContext(contextObject);
        }
    }

    public static void doFinally(@Nullable Throwable thrown, @Nullable Collection<? extends Callable<?>> callables) {
        needsContext.set(Boolean.TRUE);
        if (thrown != null && callables != null) {
            for (Callable<?> callable : callables) {
                JavaConcurrent.removeContext(callable);
            }
        }
    }

    private static boolean isLambda(Object o) {
        return o.getClass().getName().indexOf(47) != -1;
    }

    @Nullable
    public static <T> Collection<? extends Callable<T>> withContext(@Nullable Collection<? extends Callable<T>> callables, Tracer tracer) {
        if (callables == null) {
            return null;
        }
        if (callables.isEmpty()) {
            return callables;
        }
        ArrayList<Callable<T>> wrapped = JavaConcurrent.needsWrapping(callables) ? new ArrayList<Callable<T>>(callables.size()) : null;
        Boolean context = needsContext.get();
        for (Callable<T> callable : callables) {
            needsContext.set(context);
            Callable<T> potentiallyWrappedCallable = JavaConcurrent.withContext(callable, tracer);
            if (wrapped == null) continue;
            wrapped.add(potentiallyWrappedCallable);
        }
        needsContext.set(Boolean.FALSE);
        return wrapped != null ? wrapped : callables;
    }

    private static boolean needsWrapping(Collection<? extends Callable<?>> callables) {
        for (Callable<?> callable : callables) {
            if (!JavaConcurrent.isLambda(callable)) continue;
            return true;
        }
        return false;
    }

    public static void avoidPropagationOnCurrentThread() {
        needsContext.set(Boolean.FALSE);
    }

    public static void allowContextPropagationOnCurrentThread() {
        needsContext.set(Boolean.TRUE);
    }

    static {
        EXCLUDED_EXECUTABLE_TYPES.add(RunnableLambdaWrapper.class.getName());
        EXCLUDED_EXECUTABLE_TYPES.add(CallableLambdaWrapper.class.getName());
        EXCLUDED_EXECUTABLE_TYPES.add("org.springframework.jms.listener.DefaultMessageListenerContainer$AsyncMessageListenerInvoker");
        EXCLUDED_EXECUTABLE_TYPES.add("com.zaxxer.hikari.pool.HikariPool$PoolEntryCreator");
        EXCLUDED_EXECUTABLE_TYPES.add("com.github.benmanes.caffeine.cache.BoundedLocalCache.PerformCleanupTask");
    }

    public static class CallableLambdaWrapper<V>
    implements Callable<V> {
        private final Callable<V> delegate;

        public CallableLambdaWrapper(Callable<V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public V call() throws Exception {
            return this.delegate.call();
        }
    }

    public static class RunnableLambdaWrapper
    implements Runnable {
        private final Runnable delegate;

        public RunnableLambdaWrapper(Runnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() {
            this.delegate.run();
        }
    }
}

