/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.concurrent;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.concurrent.JavaConcurrent;
import co.elastic.apm.agent.sdk.state.GlobalVariables;
import co.elastic.apm.agent.util.ExecutorUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class ExecutorInstrumentation
extends TracerAwareInstrumentation {
    static final Set<String> excludedClasses = GlobalVariables.get(ExecutorInstrumentation.class, "excludedClasses", new HashSet());

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Execut").or(ElementMatchers.nameContains("Loop")).or(ElementMatchers.nameContains("Pool")).or(ElementMatchers.nameContains("Dispatch"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("java.util.concurrent.Executor")).and(ElementMatchers.not(ElementMatchers.named("org.apache.felix.resolver.ResolverImpl$DumbExecutor"))).and(ElementMatchers.not(ElementMatchers.nameContains("jetty"))).and(ElementMatchers.not(ElementMatchers.nameContains("tomcat"))).and(ElementMatchers.not(ElementMatchers.nameContains("jboss"))).and(ElementMatchers.not(ElementMatchers.nameContains("undertow"))).and(ElementMatchers.not(ElementMatchers.nameContains("netty"))).and(ElementMatchers.not(ElementMatchers.nameContains("vertx"))).and(ElementMatchers.not(ElementMatchers.nameStartsWith("com.hazelcast"))).and(ElementMatchers.not(CustomElementMatchers.isProxy()));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("concurrent", "executor");
    }

    private static boolean isExcluded(@Advice.This Executor executor) {
        return excludedClasses.contains(executor.getClass().getName()) || ExecutorUtils.isAgentExecutor(executor);
    }

    static {
        excludedClasses.add("org.apache.tomcat.util.threads.ThreadPoolExecutor");
    }

    public static class ForkJoinPoolInstrumentation
    extends ExecutorInstrumentation {
        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.hasSuperType(ElementMatchers.is(ForkJoinPool.class)).and(super.getTypeMatcher());
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("execute").and(ElementMatchers.returns(Void.TYPE)).and(ElementMatchers.takesArguments(ForkJoinTask.class)).or(ElementMatchers.named("submit").and(ElementMatchers.returns(ElementMatchers.hasSuperType(ElementMatchers.is(ForkJoinTask.class)))).and(ElementMatchers.takesArguments(ForkJoinTask.class))).or(ElementMatchers.named("invoke").and(ElementMatchers.returns(Object.class)).and(ElementMatchers.takesArguments(ForkJoinTask.class)));
        }

        @Override
        public Collection<String> getInstrumentationGroupNames() {
            return Arrays.asList("concurrent", "fork-join");
        }

        public static class AdviceClass {
            @Nullable
            @Advice.AssignReturned.ToArguments(value={@Advice.AssignReturned.ToArguments.ToArgument(value=0)})
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static ForkJoinTask<?> onExecute(@Advice.This Executor thiz, @Advice.Argument(value=0) @Nullable ForkJoinTask<?> task) {
                if (ExecutorInstrumentation.isExcluded(thiz)) {
                    return task;
                }
                return JavaConcurrent.withContext(task, TracerAwareInstrumentation.tracer);
            }

            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
            public static void onExit(@Nullable @Advice.Thrown Throwable thrown, @Advice.Argument(value=0) @Nullable ForkJoinTask<?> task) {
                JavaConcurrent.doFinally(thrown, task);
            }
        }
    }

    public static class ExecutorInvokeAnyAllInstrumentation
    extends ExecutorInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.nameStartsWith("invoke").and(ElementMatchers.nameEndsWith("Any").or(ElementMatchers.nameEndsWith("All"))).and(ElementMatchers.isPublic()).and(ElementMatchers.takesArgument(0, Collection.class)).and(ElementMatchers.isOverriddenFrom(ExecutorService.class));
        }

        @Override
        public Collection<String> getInstrumentationGroupNames() {
            return Arrays.asList("concurrent", "executor", "executor-collection");
        }

        public static class AdviceClass {
            @Nullable
            @Advice.AssignReturned.ToArguments(value={@Advice.AssignReturned.ToArguments.ToArgument(value=0)})
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static <T> Collection<? extends Callable<T>> onEnter(@Advice.This Executor thiz, @Nullable @Advice.Argument(value=0) Collection<? extends Callable<T>> callables) {
                if (ExecutorInstrumentation.isExcluded(thiz)) {
                    return callables;
                }
                return JavaConcurrent.withContext(callables, TracerAwareInstrumentation.tracer);
            }

            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
            public static void onExit(@Nullable @Advice.Thrown Throwable thrown, @Nullable @Advice.Argument(value=0) Collection<? extends Callable<?>> callables) {
                JavaConcurrent.doFinally(thrown, callables);
            }
        }
    }

    public static class ExecutorCallableInstrumentation
    extends ExecutorInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("submit").and(ElementMatchers.returns(ElementMatchers.hasSuperType(ElementMatchers.is(Future.class)))).and(ElementMatchers.takesArguments(Callable.class)).or(ElementMatchers.named("schedule").and(ElementMatchers.returns(ElementMatchers.hasSuperType(ElementMatchers.is(ScheduledFuture.class)))).and(ElementMatchers.takesArguments(Callable.class, Long.TYPE, TimeUnit.class)));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.AssignReturned.ToArguments(value={@Advice.AssignReturned.ToArguments.ToArgument(value=0)})
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Callable<?> onSubmit(@Advice.This Executor thiz, @Advice.Argument(value=0) @Nullable Callable<?> callable) {
                if (ExecutorInstrumentation.isExcluded(thiz)) {
                    return callable;
                }
                return JavaConcurrent.withContext(callable, TracerAwareInstrumentation.tracer);
            }

            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
            public static void onExit(@Nullable @Advice.Thrown Throwable thrown, @Advice.Argument(value=0) @Nullable Callable<?> callable) {
                JavaConcurrent.doFinally(thrown, callable);
            }
        }
    }

    public static class ExecutorRunnableInstrumentation
    extends ExecutorInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("execute").and(ElementMatchers.returns(Void.TYPE)).and(ElementMatchers.takesArguments(Runnable.class)).or(ElementMatchers.named("submit").and(ElementMatchers.returns(ElementMatchers.hasSuperType(ElementMatchers.is(Future.class)))).and(ElementMatchers.takesArguments(Runnable.class))).or(ElementMatchers.named("submit").and(ElementMatchers.returns(ElementMatchers.hasSuperType(ElementMatchers.is(Future.class)))).and(ElementMatchers.takesArguments(Runnable.class, Object.class))).or(ElementMatchers.named("schedule").and(ElementMatchers.returns(ElementMatchers.hasSuperType(ElementMatchers.is(ScheduledFuture.class)))).and(ElementMatchers.takesArguments(Runnable.class, Long.TYPE, TimeUnit.class)));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.AssignReturned.ToArguments(value={@Advice.AssignReturned.ToArguments.ToArgument(value=0)})
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Runnable onExecute(@Advice.This Executor thiz, @Advice.Argument(value=0) @Nullable Runnable runnable) {
                if (ExecutorInstrumentation.isExcluded(thiz)) {
                    return runnable;
                }
                return JavaConcurrent.withContext(runnable, TracerAwareInstrumentation.tracer);
            }

            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
            public static void onExit(@Nullable @Advice.Thrown Throwable thrown, @Advice.Argument(value=0) @Nullable Runnable runnable) {
                JavaConcurrent.doFinally(thrown, runnable);
            }
        }
    }
}

